<?php
$id = 'blog-list' . $block['id'];
?>
<?php
if (isset($block['data']['preview_image_help'])) : /* rendering in inserter preview */ ?>
<?php
    echo '<img src="' . plugin_dir_url(__FILE__) . $block['data']['preview_image_help'] . '" style="width:100%; height:auto;">';

else : /* rendering in editor body */
?>

    <section class="container excursion-have-fun blog-list-wrapper" data-comp="excursion-have-fun">
        <section class="container">
            <div class="row">
                <div class="col-12-12">
                    <a href="#" class="arrow-down"><i class="icon-arrow-down"></i></a>
                </div>
            </div>
            <div class="row top excursion-have-fun__row">
                <?php
                $Blogs = get_posts(array(
                    'posts_per_page'   => -1,
                    'post_type'        => 'post',
                    'post_status' => 'publish'
                ));
                foreach ($Blogs as $blog) {
                ?>
                        <article class="excursion-have-fun__item <?= get_field('mobile_position', $blog); ?>">
                            <?php
                            if (is_admin()) {
                            ?>
                                <a rel="noopener">
                                <?php
                            } else {
                                ?>
                                    <a href="<?= get_permalink($blog); ?>">
                                    <?php
                                }
                                if (get_field('video', $blog)) {
                                    ?>
                                        <figure class="img-box">
                                            <video playsinline autoplay loop muted data-type="autoplay" src="<?= get_field('video', $blog); ?>">
                                            </video>
                                        </figure>
                                    <?php
                                } elseif (get_field('card_image', $blog) || get_field('card_image_mobile', $blog)) {
                                    ?>
                                        <picture class="img-box">
                                            <?php
                                            if (get_field('card_image', $blog)) {
                                            ?>
                                                <source media="(min-width: 961px)" srcset="<?= wp_get_attachment_image_url(get_field('card_image', $blog), 'full'); ?>" />
                                            <?php
                                            }
                                            if (get_field('card_image_mobile', $blog)) {
                                            ?>
                                                <source media="(max-width: 960px) and (-webkit-min-device-pixel-ratio: 2)" srcset="<?= wp_get_attachment_image_url(get_field('card_image_mobile', $blog), 'full'); ?>" />
                                            <?php
                                            }
                                            echo wp_get_attachment_image(get_field('card_image', $blog), 'full');
                                            ?>
                                        </picture>
                                    <?php
                                }
                                    ?>
                                    <div class="description">
                                        <h3><?= $blog->post_title; ?></h3>
										<p class="date" style="text-transform:uppercase;"><?php echo date('M d, Y', strtotime($blog->post_date)); ?></p>
                                        <span class="text-mobile mobile">Read more</span>
                                    </div>
                                    </a>
                        </article>
                <?php
                }
                ?>
            </div>
        </section>
    </section>

<?php endif; ?>
<!-- /Have fun filter -->