<?php
$id = 'excursion-list' . $block['id'];
?>
<?php
if (isset($block['data']['preview_image_help'])) : /* rendering in inserter preview */ ?>
<?php
    echo '<img src="' . plugin_dir_url(__FILE__) . $block['data']['preview_image_help'] . '" style="width:100%; height:auto;">';

else : /* rendering in editor body */
?>

    <section class="container excursion-have-fun" data-comp="excursion-have-fun">
        <section class="container">
            <div class="row">
                <div class="col-12-12">
                    <a href="#" class="arrow-down"><i class="icon-arrow-down"></i></a>
                </div>
            </div>
            <div class="row top excursion-have-fun__row">
                <?php
                $Excursions = get_posts(array(
                    'posts_per_page'   => -1,
                    // 'orderby'          => 'menu_order',
                    'order'            => 'ASC',
                    'post_type'        => 'excursion',
                    'post_status' => 'publish'
                ));
                foreach ($Excursions as $excursion) {
                    $show_excursion = get_field('show_excursion', $excursion);
                    if ($show_excursion) {
                ?>
                        <article class="excursion-have-fun__item <?= get_field('mobile_position', $excursion); ?>">
                            <?php
                            if (is_admin()) {
                            ?>
                                <a rel="noopener">
                                <?php
                            } else {
                                ?>
                                    <a href="<?= get_permalink($excursion); ?>">
                                    <?php
                                }
                                if (get_field('video', $excursion)) {
                                    ?>
                                        <figure class="img-box">
                                            <video playsinline autoplay loop muted data-type="autoplay" src="<?= get_field('video', $excursion); ?>">
                                            </video>
                                        </figure>
                                    <?php
                                } elseif (get_field('card_image', $excursion) || get_field('card_image_mobile', $excursion)) {
                                    ?>
                                        <picture class="img-box">
                                            <?php
                                            if (get_field('card_image', $excursion)) {
                                            ?>
                                                <source media="(min-width: 961px)" srcset="<?= wp_get_attachment_image_url(get_field('card_image', $excursion), 'full'); ?>" />
                                            <?php
                                            }
                                            if (get_field('card_image_mobile', $excursion)) {
                                            ?>
                                                <source media="(max-width: 960px) and (-webkit-min-device-pixel-ratio: 2)" srcset="<?= wp_get_attachment_image_url(get_field('card_image_mobile', $excursion), 'full'); ?>" />
                                            <?php
                                            }
                                            echo wp_get_attachment_image(get_field('card_image', $excursion), 'full');
                                            ?>
                                        </picture>
                                    <?php
                                }
                                    ?>
                                    <div class="description">
                                        <h3><?= $excursion->post_title; ?></h3>
                                        <span class="text-mobile mobile">Explore</span>
                                    </div>
                                    </a>
                        </article>
                <?php
                    }
                }
                ?>
            </div>
        </section>
    </section>

    <nav class="container have-fun-filter" data-comp="have-fun-filter">
        <div class="row">
            <div class="col-12-12 center">
                <div class="have-fun-filter__wrapper">
                    <!-- List -->
                    <?php
                    $Categories = get_terms(array(
                        'taxonomy' => 'excursions',
                        'hide_empty' => false,
                    ));
                    ?>
                    <ul class="have-fun-filter__list">
                        <?php
                        if ($Categories) {
                            foreach ($Categories as $category) {
                        ?>
                                <li><a href="<?= get_category_link($category); ?>"><?= $category->name; ?></a></li>
                        <?php
                            }
                        }
                        ?>
                    </ul>
                    <!-- Select -->
                    <div class="have-fun-filter__select">
                        <button>choose category</button>
                    </div>
                    <!-- Close -->
                    <i class="have-fun-filter__icon-close">close</i>
                </div>
            </div>
        </div>
    </nav>
<?php endif; ?>
<!-- /Have fun filter -->