/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/banner-with-graphic-overlap/edit.js":
/*!*************************************************!*\
  !*** ./src/banner-with-graphic-overlap/edit.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Edit)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modules/ResponsiveMedia */ "./src/banner-with-graphic-overlap/modules/ResponsiveMedia.js");
/* harmony import */ var _assets_banner_with_graphic_overlap_jpg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./assets/banner-with-graphic-overlap.jpg */ "./src/banner-with-graphic-overlap/assets/banner-with-graphic-overlap.jpg");






// import "./editor.scss";

function Edit({
  attributes,
  setAttributes
}) {
  const {
    title,
    responsiveBanner,
    responsiveFigure
  } = attributes;
  console.log({
    bool: !!String(responsiveFigure?.image),
    boolVideo: !!String(responsiveFigure?.video),
    responsiveFigure
  });
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InspectorControls, {
    key: "setting"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Panel, {
    className: "components-panel--custom"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_4__["default"].control, {
    title: "Banner",
    name: "responsiveBanner",
    attribute: responsiveBanner,
    setAttributes: setAttributes
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_4__["default"].control, {
    title: "Graphic overlap",
    name: "responsiveFigure",
    attribute: responsiveFigure,
    setAttributes: setAttributes
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useBlockProps)(),
    className: "container gutenberg-component banner-with-graphic-overlap block-editor-block-list__block wp-block",
    "data-comp": "banner-with-graphic-overlap",
    "data-preview": "true"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figure", {
    className: "preview"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _assets_banner_with_graphic_overlap_jpg__WEBPACK_IMPORTED_MODULE_5__,
    alt: ""
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figure", {
    className: "banner outer-video img-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_4__["default"].edit, {
    attribute: responsiveBanner
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figcaption", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.RichText, {
    placeholder: "Optional Title...",
    tagName: "h2",
    value: title,
    className: "after-icon",
    onChange: newtitle => setAttributes({
      title: newtitle
    })
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "row"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("aside", {
    className: "col-12-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figure", {
    className: "outer-article img-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_4__["default"].edit, {
    attribute: responsiveFigure
  }))))));
}

/***/ }),

/***/ "./src/banner-with-graphic-overlap/index.js":
/*!**************************************************!*\
  !*** ./src/banner-with-graphic-overlap/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "./src/banner-with-graphic-overlap/style.scss");
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./edit */ "./src/banner-with-graphic-overlap/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./save */ "./src/banner-with-graphic-overlap/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./block.json */ "./src/banner-with-graphic-overlap/block.json");






(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_5__.name, {
  icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    "data-name": "Capa 1",
    viewBox: "0 0 81 81"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    cx: "54.3",
    cy: "48.6",
    r: "2.9",
    class: "prefix__cls-1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    cx: "21",
    cy: "27.2",
    r: "4",
    class: "prefix__cls-1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M73.1 12.7H8.2c-2.4 0-4.4 2-4.4 4.4v28.7c0 2.4 2 4.4 4.4 4.4h36.9v13.7c0 2.4 2 4.4 4.4 4.4h20.2c2.4 0 4.4-2 4.4-4.4V50.1c2-.5 3.4-2.2 3.4-4.3V17.1c0-2.4-2-4.4-4.4-4.4m-66.3 33V17.2q.2-1.3 1.4-1.4h64.9q1.3.1 1.4 1.4V34l-8.3-8.7q-.3-.5-1-.5T64 25L53.8 35l-4.2-4.9q-.4-.5-1-.5t-1.2.4L30.3 46.8l-.2.4H8.2Q7 47 6.8 45.8m64.3 10.4-3.6-4.3a1.5 1.5 0 0 0-2.3 0l-5 5.3-1.7-2.2q-.4-.6-1-.6-.8 0-1.3.5l-8.1 8.9V44.3q.1-1.2 1.4-1.4h20.2q1.3.2 1.4 1.4zm-1.4 9.2h-19l6.5-7.2 1.8 2.3q.4.5 1 .6.8 0 1.3-.5l5-5.5 4.5 5.4.3.3V64q-.1 1.3-1.4 1.4m4.4-18.5v-2.4c0-2.5-2-4.4-4.4-4.4H49.5a4.3 4.3 0 0 0-4.5 4.3v2.8H34.2l14.3-13.8 4.1 4.8q.5.5 1 .5.8 0 1.2-.4l10.3-10 9.3 10v7.5q0 .6-.3 1",
    class: "prefix__cls-1"
  })),
  /**
   * @see ./edit.js
   */
  edit: _edit__WEBPACK_IMPORTED_MODULE_3__["default"],
  /**
   * @see ./save.js
   */
  save: _save__WEBPACK_IMPORTED_MODULE_4__["default"]
});

/***/ }),

/***/ "./src/banner-with-graphic-overlap/modules/ResponsiveMedia.js":
/*!********************************************************************!*\
  !*** ./src/banner-with-graphic-overlap/modules/ResponsiveMedia.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);





const RenderImageControl = ({
  render,
  image,
  setAttributes,
  attribute,
  name
}) => {
  return render ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, "Image Desktop")), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.MediaUpload, {
    allowedTypes: ["image"],
    onSelect: media => {
      setAttributes({
        [name]: {
          ...attribute,
          image: {
            ...image,
            desktop: media.url
          }
        }
      });
    },
    multiple: false,
    render: ({
      open
    }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, image?.desktop ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: image.desktop
    }) : "", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      variant: "primary",
      onClick: open
    }, image?.desktop === null ? "Select media file" : "Select Desktop image"))
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalDivider, null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, "Image Mobile")), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.MediaUpload, {
    allowedTypes: ["image"],
    onSelect: media => {
      setAttributes({
        [name]: {
          ...attribute,
          image: {
            ...image,
            mobile: media.url
          }
        }
      });
    },
    multiple: false,
    render: ({
      open
    }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, image?.mobile ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: image.mobile
    }) : "", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      variant: "primary",
      onClick: open
    }, image?.mobile === null ? "Select media file" : "Select Mobile image"))
  }))) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null);
};
const RenderVideoControl = ({
  render,
  video,
  setAttributes,
  attribute,
  name
}) => {
  return render ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, "Video")), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.MediaUpload, {
    allowedTypes: ["video"],
    onSelect: media => {
      setAttributes({
        [name]: {
          ...attribute,
          video: media.url
        }
      });
    },
    multiple: false,
    render: ({
      open
    }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, video ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("video", {
      playsInline: true,
      autoPlay: true,
      loop: true,
      muted: true,
      "data-type": "autoplay",
      src: video
    }) : "", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      variant: "primary",
      onClick: open
    }, video === null ? "Select media file" : "Select video"))
  }))) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  control: ({
    title,
    name,
    attribute,
    setAttributes
  }) => {
    const [isVideo, setIsVideo] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const image = attribute?.image || null;
    const video = attribute?.video || null;
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      video ? setIsVideo(true) : setIsVideo(false);
    }, []);
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
      title: `${title} Responsive Image`
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
      label: isVideo ? "Video" : "Photo",
      help: "Select Media Type",
      checked: isVideo,
      onChange: newValue => {
        setIsVideo(newValue);
        setAttributes({
          [name]: {}
        });
      }
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(RenderImageControl, {
      image: image,
      render: !isVideo,
      attribute: attribute,
      setAttributes: setAttributes,
      name: name
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(RenderVideoControl, {
      video: video,
      render: isVideo,
      attribute: attribute,
      setAttributes: setAttributes,
      name: name
    }));
  },
  view: ({
    attribute
  }) => {
    const image = attribute?.image || null;
    const video = attribute?.video || null;
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, image?.desktop || image?.mobile ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("picture", {
      className: "img-box",
      style: {
        with: "100%",
        height: "100%"
      }
    }, image.desktop && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("source", {
      media: "(min-width: 961px)",
      srcSet: image.desktop
    }), image.mobile && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("source", {
      media: "(min-width: 961px)",
      srcSet: image.mobile
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: image.mobile || image.desktop,
      alt: ""
    })) : "", video && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("video", {
      playsInline: true,
      autoPlay: true,
      loop: true,
      muted: true,
      "data-type": "autoplay",
      src: video
    }));
  },
  edit: ({
    attribute
  }) => {
    const image = attribute?.image || null;
    const video = attribute?.video || null;
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, image?.desktop || image?.mobile ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("picture", {
      className: "img-box",
      style: {
        with: "100%",
        height: "100%"
      }
    }, image.desktop && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("source", {
      media: "(min-width: 961px)",
      srcSet: image.desktop
    }), image.mobile && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("source", {
      media: "(min-width: 961px)",
      srcSet: image.mobile
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: image.mobile || image.desktop,
      alt: ""
    })) : "", video && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("video", {
      playsInline: true,
      autoPlay: true,
      loop: true,
      muted: true,
      "data-type": "autoplay",
      src: video
    }));
  }
});

/***/ }),

/***/ "./src/banner-with-graphic-overlap/save.js":
/*!*************************************************!*\
  !*** ./src/banner-with-graphic-overlap/save.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ save)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modules/ResponsiveMedia */ "./src/banner-with-graphic-overlap/modules/ResponsiveMedia.js");



function save({
  attributes
}) {
  const {
    responsiveFigure,
    responsiveBanner,
    title
  } = attributes;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    ..._wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps.save(),
    className: `banner-with-graphic-overlap ${(attributes.video ? "has-video" : "", !!String(responsiveFigure?.image) || !!String(responsiveFigure?.video) ? "has-overlap-image" : "")}`,
    "data-comp": "banner-with-graphic-overlap"
  }, attributes.video && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "control-video control-video--top mobile",
    "data-comp": "control-video-mobile"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "control-video__button"
  }, "Sound on")), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figure", {
    className: "banner outer-video img-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_2__["default"].view, {
    attribute: responsiveBanner
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figcaption", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, title))), (!!String(responsiveFigure?.image) || !!String(responsiveFigure?.video)) && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "row"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("aside", {
    className: "col-12-5"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figure", {
    className: "outer-article img-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_2__["default"].view, {
    attribute: responsiveFigure
  })))));
}

/***/ }),

/***/ "./src/banner-with-graphic-overlap/style.scss":
/*!****************************************************!*\
  !*** ./src/banner-with-graphic-overlap/style.scss ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/banner-with-graphic-overlap/assets/banner-with-graphic-overlap.jpg":
/*!********************************************************************************!*\
  !*** ./src/banner-with-graphic-overlap/assets/banner-with-graphic-overlap.jpg ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/banner-with-graphic-overlap.ecae1752.jpg";

/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

module.exports = window["React"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/banner-with-graphic-overlap/block.json":
/*!****************************************************!*\
  !*** ./src/banner-with-graphic-overlap/block.json ***!
  \****************************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"$schema":"https://schemas.wp.org/trunk/block.json","apiVersion":3,"name":"nihi/banner-with-graphic-overlap","version":"0.1.0","title":"Image/video with paragraph and graphic detail","category":"nihi-blocks","description":"Image/video with paragraph and graphic detail","example":{},"supports":{"html":true},"attributes":{"title":{"type":"string"},"responsiveBanner":{"type":"object","default":{"image":{},"video":{}}},"responsiveFigure":{"type":"object","default":{"image":{},"video":{}}}},"textdomain":"nihi","editorScript":"file:./index.js","editorStyle":"file:./style-index.css","style":"file:./style-index.css","viewScript":"file:./view.js"}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/publicPath */
/******/ 	(() => {
/******/ 		var scriptUrl;
/******/ 		if (__webpack_require__.g.importScripts) scriptUrl = __webpack_require__.g.location + "";
/******/ 		var document = __webpack_require__.g.document;
/******/ 		if (!scriptUrl && document) {
/******/ 			if (document.currentScript)
/******/ 				scriptUrl = document.currentScript.src;
/******/ 			if (!scriptUrl) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				if(scripts.length) {
/******/ 					var i = scripts.length - 1;
/******/ 					while (i > -1 && !scriptUrl) scriptUrl = scripts[i--].src;
/******/ 				}
/******/ 			}
/******/ 		}
/******/ 		// When supporting browsers where an automatic publicPath is not supported you must specify an output.publicPath manually via configuration
/******/ 		// or pass an empty string ("") and set the __webpack_public_path__ variable from your code to use your own logic.
/******/ 		if (!scriptUrl) throw new Error("Automatic publicPath is not supported in this browser");
/******/ 		scriptUrl = scriptUrl.replace(/#.*$/, "").replace(/\?.*$/, "").replace(/\/[^\/]+$/, "/");
/******/ 		__webpack_require__.p = scriptUrl + "../";
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"banner-with-graphic-overlap/index": 0,
/******/ 			"banner-with-graphic-overlap/style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunknihi"] = globalThis["webpackChunknihi"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["banner-with-graphic-overlap/style-index"], () => (__webpack_require__("./src/banner-with-graphic-overlap/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map