/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/gallery-of-three-videos/edit.js":
/*!*********************************************!*\
  !*** ./src/gallery-of-three-videos/edit.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Edit)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _assets_gallery_of_three_videos_jpg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./assets/gallery-of-three-videos.jpg */ "./src/gallery-of-three-videos/assets/gallery-of-three-videos.jpg");
/* harmony import */ var _editor_scss__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./editor.scss */ "./src/gallery-of-three-videos/editor.scss");

/**
 * Retrieves the translation of text.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-i18n/
 */


/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */




/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * Those files can contain any CSS code that gets applied to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */


/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @return {Element} Element to render.
 */
function Edit({
  attributes,
  setAttributes
}) {
  const {
    sliders
  } = attributes;
  const removeSlide = i => {
    const newSlide = [...sliders];
    newSlide.splice(i, 1);
    setAttributes({
      sliders: newSlide
    });
  };
  const addSlide = val => {
    const newSlide = [...sliders];
    const slide = {
      title: 'New slide',
      status: '',
      asset: {
        type: false
      },
      cta: {
        link: '',
        text: ''
      }
    };
    newSlide.push(slide);
    setAttributes({
      sliders: newSlide
    });
  };
  const onSlideChange = (field, value, index, subfield) => {
    console.log('Before Update:', sliders);
    const updatedSliders = [...sliders];
    if (field == 'cta') {
      updatedSliders[index][field][subfield] = value;
    } else {
      updatedSliders[index][field] = value;
    }
    setAttributes({
      sliders: updatedSliders
    });
    console.log('After Update:', updatedSliders);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useBlockProps)(),
    className: "container gallery-of-three-videos block-editor-block-list__block wp-block",
    "data-comp": "gallery-of-three-videos",
    "data-preview": "true"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figure", {
    className: "preview"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _assets_gallery_of_three_videos_jpg__WEBPACK_IMPORTED_MODULE_4__,
    alt: ""
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InspectorControls, {
    key: "setting"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Panel, {
    className: "components-panel--custom"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(React.Fragment, {
    key: ".0"
  }, sliders.map((value, i) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
    key: 'item-' + i,
    title: `Slide ${i}`
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.TextControl, {
    label: "Title",
    value: value.title,
    onChange: val => onSlideChange('title', val, i)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.TextControl, {
    label: "Status",
    value: value.status,
    onChange: val => onSlideChange('status', val, i)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.MediaUploadCheck, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.MediaUpload, {
    onSelect: media => onSlideChange('asset', media, i),
    allowedTypes: ['image', 'video'],
    value: value?.asset?.id || '',
    render: ({
      open
    }) => value.asset.type ? value.asset.type == 'video' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: value.asset.thumb.src,
      alt: "",
      onClick: open
    }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: value.asset.sizes.thumbnail.url,
      alt: "",
      onClick: open
    }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      variant: "secundary",
      onClick: open,
      className: "bttn--secondary"
    }, "Select Image or video")
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.TextControl, {
    label: "CTA Link",
    value: Object.keys(value.cta).length > 0 ? value.cta.link : '',
    onChange: val => onSlideChange('cta', val, i, 'link')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.TextControl, {
    label: "CTA Text",
    value: Object.keys(value.cta).length > 0 ? value.cta.text : '',
    onChange: val => onSlideChange('cta', val, i, 'text')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
    label: "Open in new Window",
    checked: Object.keys(value.cta).length > 0 ? value.cta.openInNewTab : false,
    onChange: isChecked => onSlideChange('cta', isChecked, i, 'openInNewTab')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
    variant: "secondary",
    onClick: e => {
      removeSlide(i);
    },
    className: "bttn--danger"
  }, "Remove slide")))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
    variant: "primary",
    onClick: e => {
      addSlide('new slide');
    }
  }, "Add Slide")))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "row stretch"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12-12 gallery-of-three-videos__col no-mobile"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "gallery-of-three-videos__text"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.RichText, {
    tagName: "h3",
    value: attributes.title,
    onChange: newHeading => setAttributes({
      title: newHeading
    }),
    placeholder: "commited to"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.RichText, {
    tagName: "h2",
    value: attributes.subtitle,
    onChange: newHeading => setAttributes({
      subtitle: newHeading
    }),
    placeholder: "a shared future"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "gallery-of-three-videos__action"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.RichText, {
    tagName: "h3",
    value: attributes.listTitle,
    onChange: newHeading => setAttributes({
      listTitle: newHeading
    }),
    placeholder: "PROPERTIES"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", null, sliders.map((value, i) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
    key: i,
    "data-state": i === 0 ? 'active' : '',
    "data-index": i
  }, value.title, " ", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, value.status))))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "outer-videos"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    className: "splide",
    "aria-label": "Gallery of three videos slide"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "splide__track"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "splide__list"
  }, sliders.map((value, i) => value.cta && value.cta.link ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    key: i,
    className: "splide__slide img-box",
    href: value.cta.link,
    target: value.cta.openInNewTab ? '_blank' : '_self'
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figcaption", null, value.title && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, value.title), value.status && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, value.status), value.cta.text && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", null, value.cta.text)), value.asset.type === 'video' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("video", {
    playsInline: true,
    autoPlay: true,
    loop: true,
    muted: true,
    "data-type": "autoplay",
    src: value.asset.url
  }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: value.asset.url,
    alt: value.asset.title
  })) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    key: i,
    className: "splide__slide img-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figcaption", null, value.title && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, value.title), value.status && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, value.status), value.cta.text && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", null, value.cta.text)), value.asset.type === 'video' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("video", {
    playsInline: true,
    autoPlay: true,
    loop: true,
    muted: true,
    "data-type": "autoplay",
    src: value.asset.url
  }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: value.asset.url,
    alt: value.asset.title
  }))))))));
}

/***/ }),

/***/ "./src/gallery-of-three-videos/index.js":
/*!**********************************************!*\
  !*** ./src/gallery-of-three-videos/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "./src/gallery-of-three-videos/style.scss");
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./edit */ "./src/gallery-of-three-videos/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./save */ "./src/gallery-of-three-videos/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./block.json */ "./src/gallery-of-three-videos/block.json");

/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */


/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */


/**
 * Internal dependencies
 */




/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_5__.name, {
  icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    "data-name": "Capa 1",
    viewBox: "0 0 81 81"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M74.1 14.4H6.9c-2.4 0-4.4 2-4.4 4.4v44.7c0 2.4 2 4.4 4.4 4.4h67.2c2.4 0 4.4-2 4.4-4.4V18.8c0-2.4-2-4.4-4.4-4.4m1.4 4.4v13.6h-6V18.8l-.2-1.4H74q1.3.1 1.4 1.4m-6 16.6h6v12h-6zm-58 12h-6v-12h6zm-4.6-30h4.9q-.3.6-.3 1.4v13.6h-6V18.8q.1-1.3 1.4-1.4m-1.4 46v-13h6v13q0 .8.3 1.5H6.9q-1.3-.2-1.4-1.4M15.9 65q-1.3-.2-1.4-1.4V18.8q.1-1.3 1.4-1.4h49.2q1.3.1 1.4 1.4v44.7q-.1 1.3-1.4 1.4zm58.2 0h-4.8l.2-1.4V50.4h6v13q-.1 1.4-1.4 1.5",
    class: "prefix__cls-1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M35.5 54.8h-17a1.5 1.5 0 1 0 0 3h17a1.5 1.5 0 1 0 0-3m0 4.2h-17a1.5 1.5 0 1 0 0 3h17a1.5 1.5 0 1 0 0-3m0-8.5h-17a1.5 1.5 0 1 0 0 3h17a1.5 1.5 0 1 0 0-3m10-14.3-6-3.5q-1.4-.7-3 0-1.5 1-1.6 2.8v6.8a3 3 0 0 0 3.1 3.1q.7 0 1.6-.4l5.9-3.4q1.6-1 1.6-2.7c0-1.7-.6-2.2-1.6-2.7M44 39l-6 3.4-.1-.1v-6.9h.1l6 3.4z",
    class: "prefix__cls-1"
  })),
  /**
   * @see ./edit.js
   */
  edit: _edit__WEBPACK_IMPORTED_MODULE_3__["default"],
  /**
   * @see ./save.js
   */
  save: _save__WEBPACK_IMPORTED_MODULE_4__["default"]
});

/***/ }),

/***/ "./src/gallery-of-three-videos/save.js":
/*!*********************************************!*\
  !*** ./src/gallery-of-three-videos/save.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ save)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);

/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */


/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
function save(props) {
  const {
    attributes
  } = props;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    ..._wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps.save(),
    className: "container gallery-of-three-videos",
    "data-comp": "gallery-of-three-videos"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "row stretch"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12-12 gallery-of-three-videos__col"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "gallery-of-three-videos__text"
  }, attributes.title && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.RichText.Content, {
    tagName: "h3",
    value: attributes.title
  }), attributes.subtitle && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.RichText.Content, {
    tagName: "h2",
    value: attributes.subtitle
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "gallery-of-three-videos__action no-mobile"
  }, attributes.listTitle && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, attributes.listTitle), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("ul", null, attributes.sliders.map((value, i) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("li", {
    key: i,
    "data-state": i === 0 ? 'active' : '',
    "data-index": i
  }, value.title, " ", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, value.status))))))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "outer-videos",
    style: `--subtitle-length: ${attributes.subtitle.length}`
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    className: "splide",
    "aria-label": "Gallery of three videos slide"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "splide__track"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "splide__list"
  }, attributes.sliders.map((value, i) => value.cta && value.cta.link ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    key: i,
    className: `splide__slide img-box has-link`,
    href: value.cta.link,
    target: value.cta.openInNewTab ? '_blank' : '_self',
    "data-text": value.cta.text,
    rel: "noopener",
    "data-element": "video-container"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figcaption", null, value.title && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, value.title), value.status && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h4", null, value.status), value.cta.text && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", null, value.cta.text)), value.asset.type === 'video' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("video", {
    playsInline: true,
    autoPlay: true,
    loop: true,
    muted: true,
    "data-type": "autoplay",
    src: value.asset.url
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "control-videox mobile",
    "data-comp": "control-video-mobile"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "control-video__button"
  }, "Sound on"))) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: value.asset.url,
    alt: value.asset.title
  })) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    key: i,
    className: "splide__slide img-box",
    "data-element": "video-container"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figcaption", null, value.title && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, value.title), value.status && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h4", null, value.status), value.cta.text && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", null, value.cta.text)), value.asset.type === 'video' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("video", {
    playsInline: true,
    autoPlay: true,
    loop: true,
    muted: true,
    "data-type": "autoplay",
    src: value.asset.url
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "control-videox mobile",
    "data-comp": "control-video-mobile"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "control-video__button"
  }, "Sound on"))) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: value.asset.url,
    alt: value.asset.title
  }))))))));
}

/***/ }),

/***/ "./src/gallery-of-three-videos/editor.scss":
/*!*************************************************!*\
  !*** ./src/gallery-of-three-videos/editor.scss ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/gallery-of-three-videos/style.scss":
/*!************************************************!*\
  !*** ./src/gallery-of-three-videos/style.scss ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/gallery-of-three-videos/assets/gallery-of-three-videos.jpg":
/*!************************************************************************!*\
  !*** ./src/gallery-of-three-videos/assets/gallery-of-three-videos.jpg ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/gallery-of-three-videos.d27d1300.jpg";

/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

module.exports = window["React"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/gallery-of-three-videos/block.json":
/*!************************************************!*\
  !*** ./src/gallery-of-three-videos/block.json ***!
  \************************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"$schema":"https://schemas.wp.org/trunk/block.json","apiVersion":3,"name":"nihi/gallery-of-three-videos","version":"0.1.0","title":"Autoplay animated gallery of three videos/images","category":"nihi-blocks","description":"Autoplay animated gallery of three videos/images description.","example":{},"supports":{"html":true},"attributes":{"title":{"type":"string","default":"commited to"},"subtitle":{"type":"string","default":"a shared future"},"listTitle":{"type":"string","default":"properties"},"sliders":{"type":"array","default":[],"items":{"type":"object","properties":{"title":{"type":"string","default":""},"status":{"type":"string","default":""},"asset":{"type":"object","default":{}},"cta":{"type":"object","default":{}}}}}},"textdomain":"nihi","editorScript":"file:./index.js","editorStyle":"file:./index.css","style":"file:./style-index.css","viewScript":"file:./view.js"}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/publicPath */
/******/ 	(() => {
/******/ 		var scriptUrl;
/******/ 		if (__webpack_require__.g.importScripts) scriptUrl = __webpack_require__.g.location + "";
/******/ 		var document = __webpack_require__.g.document;
/******/ 		if (!scriptUrl && document) {
/******/ 			if (document.currentScript)
/******/ 				scriptUrl = document.currentScript.src;
/******/ 			if (!scriptUrl) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				if(scripts.length) {
/******/ 					var i = scripts.length - 1;
/******/ 					while (i > -1 && !scriptUrl) scriptUrl = scripts[i--].src;
/******/ 				}
/******/ 			}
/******/ 		}
/******/ 		// When supporting browsers where an automatic publicPath is not supported you must specify an output.publicPath manually via configuration
/******/ 		// or pass an empty string ("") and set the __webpack_public_path__ variable from your code to use your own logic.
/******/ 		if (!scriptUrl) throw new Error("Automatic publicPath is not supported in this browser");
/******/ 		scriptUrl = scriptUrl.replace(/#.*$/, "").replace(/\?.*$/, "").replace(/\/[^\/]+$/, "/");
/******/ 		__webpack_require__.p = scriptUrl + "../";
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"gallery-of-three-videos/index": 0,
/******/ 			"gallery-of-three-videos/style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunknihi"] = globalThis["webpackChunknihi"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["gallery-of-three-videos/style-index"], () => (__webpack_require__("./src/gallery-of-three-videos/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map