/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/have-fun-categories-crosselling/edit.js":
/*!*****************************************************!*\
  !*** ./src/have-fun-categories-crosselling/edit.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Edit)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _editor_scss__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./editor.scss */ "./src/have-fun-categories-crosselling/editor.scss");

/**
 * Retrieves the translation of text.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-i18n/
 */


/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */



/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * Those files can contain any CSS code that gets applied to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */


/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @return {Element} Element to render.
 */
function Edit(props) {
  const {
    attributes,
    setAttributes
  } = props;
  const imageHoverLink = (value, type) => {
    const {
      link,
      title,
      target
    } = attributes.imageLink;
    const updatedImageLink = {
      ...attributes.imageLink,
      [type === 'link' ? 'link' : type === 'title' ? 'title' : 'target']: value
    };
    setAttributes({
      imageLink: updatedImageLink
    });
  };
  const videoHoverLink = (value, type) => {
    const {
      link,
      title,
      target
    } = attributes.videoLink;
    const updatedVideoLink = {
      ...attributes.videoLink,
      [type === 'link' ? 'link' : type === 'title' ? 'title' : 'target']: value
    };
    setAttributes({
      videoLink: updatedVideoLink
    });
  };
  const getImageHoverLink = () => {
    const link = attributes.imageLink.link && attributes.imageLink.link.trim() !== '' ? attributes.imageLink.link : '';
    if (link == '') {
      return;
    }
    const target = attributes.imageLink.target ? '_blank' : '_self';
    const title = attributes.imageLink.title && attributes.imageLink.title.trim() !== '' ? attributes.imageLink.title : link;
    const anchorTag = `<a href="${link}" className="button" target="${target}">${title}</a>`;
    const anchorElement = new DOMParser().parseFromString(anchorTag, 'text/html');
    const anchorContent = anchorElement.body.firstChild;
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(AnchorElement, {
      href: anchorContent.href,
      className: anchorContent.className,
      target: anchorContent.target
    }, anchorContent.textContent);
  };
  const getVideoHoverLink = () => {
    const link = attributes.videoLink.link && attributes.videoLink.link.trim() !== '' ? attributes.videoLink.link : '';
    if (link == '') {
      return;
    }
    const target = attributes.videoLink.target ? '_blank' : '_self';
    const title = attributes.videoLink.title && attributes.videoLink.title.trim() !== '' ? attributes.videoLink.title : link;
    const anchorTag = `<a href="${link}" className="button" target="${target}">${title}</a>`;
    const anchorElement = new DOMParser().parseFromString(anchorTag, 'text/html');
    const anchorContent = anchorElement.body.firstChild;
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(AnchorElement, {
      href: anchorContent.href,
      className: anchorContent.className,
      target: anchorContent.target
    }, anchorContent.textContent);
  };
  const AnchorElement = ({
    href,
    className,
    target,
    children
  }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: href,
    className: className,
    target: target
  }, children);
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useBlockProps)(),
    className: "container have-fun-categories-crosselling gutenberg-component block-editor-block-list__block wp-block"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InspectorControls, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
    title: "Image hover link"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.TextControl, {
    help: "Only accepts URL",
    label: "Link",
    onChange: newValue => imageHoverLink(newValue, 'link'),
    value: attributes.imageLink.link
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.TextControl, {
    help: "Title to show",
    label: "Title",
    onChange: newValue => imageHoverLink(newValue, 'title'),
    value: attributes.imageLink.title
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: "Open in new tab?",
    help: "Link is open in new tab",
    checked: attributes.imageLink.target,
    onChange: newValue => imageHoverLink(newValue, 'target')
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
    title: "Video hover link"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.TextControl, {
    help: "Only accepts URL",
    label: "Link",
    onChange: newValue => videoHoverLink(newValue, 'link'),
    value: attributes.videoLink.link
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.TextControl, {
    help: "Title to show",
    label: "Title",
    onChange: newValue => videoHoverLink(newValue, 'title'),
    value: attributes.videoLink.title
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
    label: "Open in new tab?",
    help: "Link is open in new tab",
    checked: attributes.videoLink.target,
    onChange: newValue => videoHoverLink(newValue, 'target')
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", {
    className: "row"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12-12 center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.RichText, {
    tagName: "h3",
    value: attributes.heading,
    onChange: newHeading => setAttributes({
      heading: newHeading
    }),
    placeholder: "H3 TITLE"
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "row"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figure", {
    className: "col-12-6 img-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.MediaUpload, {
    onSelect: media => setAttributes({
      imageUrl: media.url
    }),
    allowedTypes: ['image'],
    value: attributes.imageUrl,
    render: ({
      open
    }) => attributes.imageUrl ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: attributes.imageUrl,
      alt: "",
      onClick: open
    }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      variant: "primary",
      onClick: open
    }, "Select Image")
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figcaption", null, getImageHoverLink())), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figure", {
    className: "col-12-6 img-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.MediaUpload, {
    onSelect: media => setAttributes({
      videoUrl: media.url
    }),
    allowedTypes: ['video'],
    value: attributes.videoUrl,
    render: ({
      open
    }) => attributes.videoUrl ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("video", {
      playsInline: true,
      autoPlay: true,
      loop: true,
      muted: true,
      "data-type": "autoplay",
      onClick: open,
      src: attributes.videoUrl
    }) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      variant: "primary",
      onClick: open
    }, "Select Video")
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figcaption", null, getVideoHoverLink()))));
}

/***/ }),

/***/ "./src/have-fun-categories-crosselling/index.js":
/*!******************************************************!*\
  !*** ./src/have-fun-categories-crosselling/index.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "./src/have-fun-categories-crosselling/style.scss");
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./edit */ "./src/have-fun-categories-crosselling/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./save */ "./src/have-fun-categories-crosselling/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./block.json */ "./src/have-fun-categories-crosselling/block.json");

/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */


/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */


/**
 * Internal dependencies
 */




/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_5__.name, {
  icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    "data-name": "Capa 1",
    viewBox: "0 0 81 81"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M66.7 73h-55a1.5 1.5 0 1 0 0 3h55a1.5 1.5 0 1 0 0-3",
    class: "prefix__cls-1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    cx: "74.1",
    cy: "12.6",
    r: "3.5",
    class: "prefix__cls-1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M81 5.4V2.5H67.5c-2.5 0-4.4 2-4.4 4.4V36c0 2.4 2 4.4 4.4 4.4H81v-3H68l9.5-11.6 3.5 4.4v-4.8l-2.3-3q-.5-.5-1.2-.5t-1.2.5L66.1 35.3V6.9q.1-1.3 1.4-1.4zM23.6 64.7a1.5 1.5 0 1 0 0 3h25a1.5 1.5 0 1 0 0-3z",
    class: "prefix__cls-1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    cx: "31.6",
    cy: "33.6",
    r: "4",
    class: "prefix__cls-1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M26 61.1h29.7c2.4 0 4.4-2 4.4-4.4V28.5c0-2.4-2-4.4-4.4-4.4H26c-2.5 0-4.4 2-4.4 4.4v28.2c0 2.5 2 4.4 4.4 4.4m-1.4-32.6q.1-1.2 1.4-1.4h29.7q1.2.2 1.4 1.4v14.6L51 36.6q-.5-.5-1.1-.5t-1 .5l-8 7.6-3-3.6q-.5-.5-1.1-.5t-1.1.4L24.6 51.3zm0 27 12-11.7 3.1 3.5q.5.5 1 .6.8 0 1.2-.5l8-7.6 7 7.6h.2v9.3q-.2 1.3-1.4 1.4H26q-1.3-.1-1.4-1.4zM65 44a1.5 1.5 0 1 0 0 3h16v-3zm-51.3 1.5c2.4 0 4.4-2 4.4-4.4V11.9c0-2.5-2-4.4-4.5-4.4H0v2.9h13.7q1.3.1 1.4 1.5v18.9l-5.3-7.1q-.4-.6-1.1-.6t-1.2.5L0 32.4V37l8.5-10 6 8.1.5.5V41q-.1 1.2-1.4 1.4H0v2.9h13.7m-2.2 5.3q-.1-1.4-1.6-1.5H0v3h10q1.3-.1 1.4-1.5",
    class: "prefix__cls-1"
  })),
  /**
   * @see ./edit.js
   */
  edit: _edit__WEBPACK_IMPORTED_MODULE_3__["default"],
  /**
   * @see ./save.js
   */
  save: _save__WEBPACK_IMPORTED_MODULE_4__["default"]
});

/***/ }),

/***/ "./src/have-fun-categories-crosselling/save.js":
/*!*****************************************************!*\
  !*** ./src/have-fun-categories-crosselling/save.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ save)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);

/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */


/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
function save(props) {
  const {
    attributes
  } = props;
  const heading = attributes.heading;
  const imageUrl = attributes.imageUrl;
  const imageLink = attributes.imageLink;
  const videoUrl = attributes.videoUrl;
  const videoLink = attributes.videoLink;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    ..._wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps.save(),
    className: "container have-fun-categories-crosselling gutenberg-component"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", {
    className: "row"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "col-12-12 center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", null), heading && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.RichText.Content, {
    tagName: "h3",
    value: heading,
    className: "heading"
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "row"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figure", {
    className: "col-12-6 img-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: imageUrl,
    alt: ""
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figcaption", null, imageLink && imageLink.link && imageLink.link.trim() !== "" ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: imageLink.link,
    className: "button",
    target: imageLink.target ? "_blank" : "_self"
  }, imageLink.title && imageLink.title.trim() !== "" ? imageLink.title : imageLink.link) : null)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figure", {
    className: "col-12-6 img-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("video", {
    playsInline: true,
    autoPlay: true,
    loop: true,
    muted: true,
    "data-type": "autoplay",
    src: videoUrl
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figcaption", null, videoLink && videoLink.link && videoLink.link.trim() !== "" ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: videoLink.link,
    className: "button",
    target: videoLink.target ? "_blank" : "_self"
  }, videoLink.title && videoLink.title.trim() !== "" ? videoLink.title : videoLink.link) : null))));
}

/***/ }),

/***/ "./src/have-fun-categories-crosselling/editor.scss":
/*!*********************************************************!*\
  !*** ./src/have-fun-categories-crosselling/editor.scss ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/have-fun-categories-crosselling/style.scss":
/*!********************************************************!*\
  !*** ./src/have-fun-categories-crosselling/style.scss ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

module.exports = window["React"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/have-fun-categories-crosselling/block.json":
/*!********************************************************!*\
  !*** ./src/have-fun-categories-crosselling/block.json ***!
  \********************************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"$schema":"https://schemas.wp.org/trunk/block.json","apiVersion":3,"name":"nihi/have-fun-categories-crosselling","version":"0.1.0","title":"Have fun categories crosselling","category":"nihi-blocks","description":"Block Have fun categories crosselling","example":{},"supports":{"html":true},"attributes":{"heading":{"type":"string"},"imageUrl":{"type":"string"},"imageLink":{"type":"object","default":{"link":"","title":"","target":false}},"videoUrl":{"type":"string"},"videoLink":{"type":"object","default":{"link":"","title":"","target":false}}},"textdomain":"nihi","editorScript":"file:./index.js","editorStyle":"file:./index.css","style":"file:./style-index.css","viewScript":"file:./view.js"}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"have-fun-categories-crosselling/index": 0,
/******/ 			"have-fun-categories-crosselling/style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunknihi"] = globalThis["webpackChunknihi"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["have-fun-categories-crosselling/style-index"], () => (__webpack_require__("./src/have-fun-categories-crosselling/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map