/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*******************************************!*\
  !*** ./src/imgs-overlapping-text/view.js ***!
  \*******************************************/
class ImgsOverlappingText {
  constructor(sel) {
    // view
    this.component = document.querySelector(sel);
    if (this.component) {
      this.init();
    }
  }
  init() {
    this.parallax();
  }
  parallax() {
    if (window.innerWidth > 961) {
      gsap.to(".img-box__first", {
        yPercent: 70,
        ease: "none",
        scrollTrigger: {
          trigger: ".imgs-overlapping-text",
          scrub: true
        }
      });
      gsap.to(".img-box__second", {
        yPercent: 80,
        ease: "none",
        scrollTrigger: {
          trigger: ".imgs-overlapping-text",
          scrub: true
        }
      });
      gsap.to(".img-box__last", {
        yPercent: -30,
        ease: "none",
        scrollTrigger: {
          trigger: ".imgs-overlapping-text",
          scrub: true
        }
      });
    } else {
      gsap.to(".imgs-overlapping-text__overflow", {
        x: -260,
        ease: "none",
        scrollTrigger: {
          trigger: ".imgs-overlapping-text",
          scrub: true,
          start: "top top",
          end: "bottom 80%",
          pin: true
        }
      });
      gsap.to(".imgs-overlapping-text h2", {
        x: 60,
        ease: "none",
        scrollTrigger: {
          trigger: ".imgs-overlapping-text",
          scrub: true,
          start: "top top",
          end: "bottom 100%"
        }
      });
    }
  }
}
if (document.querySelectorAll('[data-comp="imgs-overlapping-text"]').length) {
  this.imgsOverlappingText = new ImgsOverlappingText('[data-comp="imgs-overlapping-text"]');
}
/******/ })()
;
//# sourceMappingURL=view.js.map