<section class="container table-rates">
    <header class="row">
        <div class="col-12-12">
            <?= get_field('title'); ?>
        </div>
    </header>
    <div class="row">
        <div class="col-12-12">
            <div class="line head">
                <div></div>
                <div>
                    <span class="year"><?= date('Y'); ?></span>
                    <span>Green</span>
                    <span>High</span>
                </div>
                <div>
                    <span class="year"><?= date('Y')+1; ?></span>
                    <span>Green</span>
                    <span>High</span>
                </div>
            </div>
            <?php
            $rates = get_field('rates');
            if($rates == 'all'){
                $Villas = get_posts(array(
                    'posts_per_page' => -1,
                    'post_type' => 'villas'
                ));
            } elseif($rates == 'individual'){
                $Villas = get_field('villas_relationship');

            } elseif($rates == 'category'){
                $Villas = get_posts(array(
                    'posts_per_page' => -1,
                    'post_type' => 'villas',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'villas_type',
                            'field' => 'term_id',
                            'terms' => get_field('villas_category'),
                        )
                    )
                ));
            }

            foreach($Villas as $villa){
                ?>
                <a href="<?= get_permalink($villa); ?>" class="line">
                    <div>
                        <h3><?= $villa->post_title; ?></h3>
                    </div>
                    <?php
                    if(have_rows('rates', $villa)){
                        while(have_rows('rates', $villa)){
                            the_row();
                            if(get_sub_field('year') == date('Y') || get_sub_field('year') == date('Y')+1){
                                ?>
                                <div>
                                    <span>USD <?= get_sub_field('green_price'); ?></span>
                                    <span>USD <?= get_sub_field('high_price'); ?></span>
                                </div>
                                <?php
                            }
                        }
                    }
                    ?>
                    <figure class="hoverimage img-box no-mobile">
                        <?= wp_get_attachment_image(get_field('backgrond_image', $villa), 'full'); ?>
                    </figure>
                </a>
                <?php
            }
            ?>
        </div>
    </div>
</section>