/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/side-by-side-image-video-container/edit.js":
/*!********************************************************!*\
  !*** ./src/side-by-side-image-video-container/edit.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Edit)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modules/ResponsiveMedia */ "./src/side-by-side-image-video-container/modules/ResponsiveMedia.js");
/* harmony import */ var _assets_side_by_side_image_video_container_jpg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./assets/side-by-side-image-video-container.jpg */ "./src/side-by-side-image-video-container/assets/side-by-side-image-video-container.jpg");






function Edit({
  attributes,
  setAttributes
}) {
  const {
    title,
    leftText,
    leftResponsive,
    rightText,
    rightResponsive,
    image,
    video
  } = attributes;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.InspectorControls, {
    key: "setting"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Panel, {
    className: "components-panel--custom"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_4__["default"].control, {
    title: "Media Left",
    name: "leftResponsive",
    attribute: leftResponsive,
    setAttributes: setAttributes
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_4__["default"].control, {
    title: "Media Right",
    name: "rightResponsive",
    attribute: rightResponsive,
    setAttributes: setAttributes
  })))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    ...(0,_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.useBlockProps)(),
    className: "side-by-side-image-video container block-editor-block-list__block wp-block",
    "data-comp": "side-by-side-image-video",
    "data-preview": "true"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("figure", {
    className: "preview"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _assets_side_by_side_image_video_container_jpg__WEBPACK_IMPORTED_MODULE_5__,
    alt: ""
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", {
    className: "row center"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.RichText, {
    placeholder: "Enter title here...",
    tagName: "h2",
    value: title,
    onChange: newtitle => setAttributes({
      title: newtitle
    }),
    className: "center col-12-10"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "row full-width middle"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("article", {
    className: "left-side",
    "data-target": "left"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("aside", {
    className: "img-box video-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_4__["default"].edit, {
    attribute: leftResponsive
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.RichText, {
    placeholder: "Enter left text here...",
    tagName: "h3",
    value: leftText,
    onChange: val => setAttributes({
      leftText: val
    })
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("article", {
    className: "right-side",
    "data-target": "right"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("aside", {
    className: "img-box video-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_4__["default"].edit, {
    attribute: rightResponsive
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.RichText, {
    placeholder: "Enter right text here...",
    tagName: "h3",
    value: rightText,
    onChange: val => setAttributes({
      rightText: val
    })
  }))))));
}

/***/ }),

/***/ "./src/side-by-side-image-video-container/index.js":
/*!*********************************************************!*\
  !*** ./src/side-by-side-image-video-container/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/blocks */ "@wordpress/blocks");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.scss */ "./src/side-by-side-image-video-container/style.scss");
/* harmony import */ var _edit__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./edit */ "./src/side-by-side-image-video-container/edit.js");
/* harmony import */ var _save__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./save */ "./src/side-by-side-image-video-container/save.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./block.json */ "./src/side-by-side-image-video-container/block.json");






(0,_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__.registerBlockType)(_block_json__WEBPACK_IMPORTED_MODULE_5__.name, {
  icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    "data-name": "Capa 1",
    viewBox: "0 0 81 81"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M31.2 19.9a1.5 1.5 0 1 0 0 3h17.6a1.5 1.5 0 1 0 0-3zm-5.5-3.1h29.1a1.5 1.5 0 1 0 0-3H25.7a1.5 1.5 0 1 0 0 3",
    class: "prefix__cls-1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    cx: "48.8",
    cy: "39.2",
    r: "4",
    class: "prefix__cls-1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("circle", {
    cx: "13.8",
    cy: "39.2",
    r: "4",
    class: "prefix__cls-1"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M73 29.7H41.7v-2.3a1.5 1.5 0 1 0-3 0v2.3H8.1c-2.5 0-4.4 2-4.4 4.4v28.7c0 2.4 2 4.4 4.4 4.4h64.8c2.5 0 4.4-2 4.4-4.4V34.1c0-2.4-2-4.4-4.4-4.4m0 34H43.1q-1.2-.1-1.4-1.4v-1.2L54 49.4l3 3.5q.5.5 1.1.5.8.1 1.2-.4l7.9-7.6 7.1 7.6h.1v9.3q-.1 1.3-1.4 1.4m0-31q1.2.1 1.3 1.4v14.6l-6-6.5q-.6-.5-1.1-.5-.7 0-1.1.4l-7.9 7.7-3-3.6q-.5-.5-1.1-.5T53 46L41.8 57V34.1q.2-1.3 1.4-1.4zm-65 0h30.8v15.4l-5.6-6q-.4-.3-1-.4-.7 0-1.1.4l-7.9 7.7-3-3.6q-.5-.5-1.1-.5t-1.2.4l-11.2 11V34q.1-1 1.3-1.3M6.8 62.8v-1.6L19 49.4l3 3.5q.5.5 1.1.5.7.1 1.1-.4l8-7.6 6.7 7.1v9.8q0 1 .5 2H8q-1.3-.2-1.4-1.5Z",
    class: "prefix__cls-1"
  })),
  edit: _edit__WEBPACK_IMPORTED_MODULE_3__["default"],
  save: _save__WEBPACK_IMPORTED_MODULE_4__["default"]
});

/***/ }),

/***/ "./src/side-by-side-image-video-container/modules/ResponsiveMedia.js":
/*!***************************************************************************!*\
  !*** ./src/side-by-side-image-video-container/modules/ResponsiveMedia.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);





const RenderImageControl = ({
  render,
  image,
  setAttributes,
  attribute,
  name
}) => {
  return render ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, "Image Desktop")), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.MediaUpload, {
    allowedTypes: ["image"],
    onSelect: media => {
      setAttributes({
        [name]: {
          ...attribute,
          image: {
            ...image,
            desktop: media.url
          }
        }
      });
    },
    multiple: false,
    render: ({
      open
    }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, image?.desktop ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: image.desktop
    }) : "", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      variant: "primary",
      onClick: open
    }, image?.desktop === null ? "Select media file" : "Select Desktop image"))
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.__experimentalDivider, null), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, "Image Mobile")), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.MediaUpload, {
    allowedTypes: ["image"],
    onSelect: media => {
      setAttributes({
        [name]: {
          ...attribute,
          image: {
            ...image,
            mobile: media.url
          }
        }
      });
    },
    multiple: false,
    render: ({
      open
    }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, image?.mobile ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: image.mobile
    }) : "", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      variant: "primary",
      onClick: open
    }, image?.mobile === null ? "Select media file" : "Select Mobile image"))
  }))) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null);
};
const RenderVideoControl = ({
  render,
  video,
  setAttributes,
  attribute,
  name,
  hasSound
}) => {
  return render ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, "Video")), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_2__.MediaUpload, {
    allowedTypes: ["video"],
    onSelect: media => {
      setAttributes({
        [name]: {
          ...attribute,
          video: media.url
        }
      });
    },
    multiple: false,
    render: ({
      open
    }) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, video ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("video", {
      playsInline: true,
      autoPlay: true,
      loop: true,
      muted: true,
      "data-type": "autoplay",
      src: video
    }) : "", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
      variant: "primary",
      onClick: open
    }, video === null ? "Select media file" : "Select video"))
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
    label: "Video have sound?",
    checked: attribute?.hasSound !== undefined ? attribute?.hasSound : true,
    onChange: hasSound => {
      setAttributes({
        [name]: {
          ...attribute,
          hasSound
        }
      });
    }
  }))) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  control: ({
    title,
    name,
    attribute,
    setAttributes
  }) => {
    const [isVideo, setIsVideo] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const image = attribute?.image || null;
    const video = attribute?.video || null;
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      video ? setIsVideo(true) : setIsVideo(false);
    }, []);
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelBody, {
      title: `${title} Responsive Image`
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.PanelRow, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.ToggleControl, {
      label: isVideo ? "Video" : "Photo",
      help: "Select Media Type",
      checked: isVideo,
      onChange: newValue => {
        setIsVideo(newValue);
        setAttributes({
          [name]: {}
        });
      }
    })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(RenderImageControl, {
      image: image,
      render: !isVideo,
      attribute: attribute,
      setAttributes: setAttributes,
      name: name
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(RenderVideoControl, {
      video: video,
      render: isVideo,
      attribute: attribute,
      setAttributes: setAttributes,
      name: name
    }));
  },
  view: ({
    attribute
  }) => {
    const image = attribute?.image || null;
    const video = attribute?.video || null;
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, image?.desktop || image?.mobile ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("picture", {
      className: "img-box",
      style: {
        width: "100%",
        height: "100%"
      }
    }, image.desktop && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("source", {
      media: "(min-width: 961px)",
      srcSet: image.desktop
    }), image.mobile && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("source", {
      media: "(min-width: 961px)",
      srcSet: image.mobile
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: image.mobile || image.desktop,
      alt: ""
    })) : "", video && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("video", {
      playsInline: true,
      autoPlay: true,
      loop: true,
      muted: true,
      "data-type": "autoplay",
      src: video,
      "data-sound": attribute?.hasSound !== undefined ? attribute?.hasSound : true
    }), attribute.hasSound && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      class: "control-video control-video--top mobile",
      "data-comp": "control-video-mobile"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
      class: "control-video__button"
    }, "Sound on"))));
  },
  edit: ({
    attribute
  }) => {
    const image = attribute?.image || null;
    const video = attribute?.video || null;
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, image?.desktop || image?.mobile ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("picture", {
      className: "img-box",
      style: {
        width: "100%",
        height: "100%"
      }
    }, image.desktop && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("source", {
      media: "(min-width: 961px)",
      srcSet: image.desktop
    }), image.mobile && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("source", {
      media: "(min-width: 961px)",
      srcSet: image.mobile
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: image.mobile || image.desktop,
      alt: ""
    })) : "", video && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("video", {
      playsInline: true,
      autoPlay: true,
      loop: true,
      muted: true,
      "data-type": "autoplay",
      src: video
    }));
  }
});

/***/ }),

/***/ "./src/side-by-side-image-video-container/save.js":
/*!********************************************************!*\
  !*** ./src/side-by-side-image-video-container/save.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ save)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modules/ResponsiveMedia */ "./src/side-by-side-image-video-container/modules/ResponsiveMedia.js");



function save({
  attributes
}) {
  const {
    title,
    leftText,
    leftResponsive,
    rightText,
    rightResponsive
  } = attributes;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("section", {
    ..._wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.useBlockProps.save(),
    className: "side-by-side-image-video container",
    "data-comp": "side-by-side-image-video"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", {
    className: "row center"
  }, title && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.RichText.Content, {
    tagName: "h2",
    className: "center col-12-10",
    value: title
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "row full-width middle"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("article", {
    className: "left-side",
    "data-target": "left",
    "data-element": "video-container"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("aside", {
    className: "img-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_2__["default"].view, {
    attribute: leftResponsive
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", null, leftText && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.RichText.Content, {
    tagName: "h3",
    value: leftText
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("article", {
    className: "right-side",
    "data-target": "right",
    "data-element": "video-container"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("aside", {
    className: "video-box"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_modules_ResponsiveMedia__WEBPACK_IMPORTED_MODULE_2__["default"].view, {
    attribute: rightResponsive
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", null, rightText && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_1__.RichText.Content, {
    tagName: "h3",
    value: rightText
  })))));
}

/***/ }),

/***/ "./src/side-by-side-image-video-container/style.scss":
/*!***********************************************************!*\
  !*** ./src/side-by-side-image-video-container/style.scss ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/side-by-side-image-video-container/assets/side-by-side-image-video-container.jpg":
/*!**********************************************************************************************!*\
  !*** ./src/side-by-side-image-video-container/assets/side-by-side-image-video-container.jpg ***!
  \**********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/side-by-side-image-video-container.3752737e.jpg";

/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

module.exports = window["React"];

/***/ }),

/***/ "@wordpress/block-editor":
/*!*************************************!*\
  !*** external ["wp","blockEditor"] ***!
  \*************************************/
/***/ ((module) => {

module.exports = window["wp"]["blockEditor"];

/***/ }),

/***/ "@wordpress/blocks":
/*!********************************!*\
  !*** external ["wp","blocks"] ***!
  \********************************/
/***/ ((module) => {

module.exports = window["wp"]["blocks"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ ((module) => {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/side-by-side-image-video-container/block.json":
/*!***********************************************************!*\
  !*** ./src/side-by-side-image-video-container/block.json ***!
  \***********************************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"$schema":"https://schemas.wp.org/trunk/block.json","apiVersion":3,"name":"nihi/side-by-side-image-video-container","version":"0.1.0","title":"Side by side image video container","category":"nihi-blocks","description":"Side by side image video container.","example":{},"supports":{"html":true},"attributes":{"sound":{"type":"boolean","default":false},"title":{"type":"string","default":""},"leftText":{"type":"string","default":""},"leftResponsive":{"type":"object","default":{"image":{},"video":{}}},"rightText":{"type":"string","default":""},"rightResponsive":{"type":"object","default":{"image":{},"video":{}}}},"textdomain":"nihi","editorScript":"file:./index.js","editorStyle":"file:./style-index.css","style":"file:./style-index.css","viewScript":"file:./view.js"}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/publicPath */
/******/ 	(() => {
/******/ 		var scriptUrl;
/******/ 		if (__webpack_require__.g.importScripts) scriptUrl = __webpack_require__.g.location + "";
/******/ 		var document = __webpack_require__.g.document;
/******/ 		if (!scriptUrl && document) {
/******/ 			if (document.currentScript)
/******/ 				scriptUrl = document.currentScript.src;
/******/ 			if (!scriptUrl) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				if(scripts.length) {
/******/ 					var i = scripts.length - 1;
/******/ 					while (i > -1 && !scriptUrl) scriptUrl = scripts[i--].src;
/******/ 				}
/******/ 			}
/******/ 		}
/******/ 		// When supporting browsers where an automatic publicPath is not supported you must specify an output.publicPath manually via configuration
/******/ 		// or pass an empty string ("") and set the __webpack_public_path__ variable from your code to use your own logic.
/******/ 		if (!scriptUrl) throw new Error("Automatic publicPath is not supported in this browser");
/******/ 		scriptUrl = scriptUrl.replace(/#.*$/, "").replace(/\?.*$/, "").replace(/\/[^\/]+$/, "/");
/******/ 		__webpack_require__.p = scriptUrl + "../";
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"side-by-side-image-video-container/index": 0,
/******/ 			"side-by-side-image-video-container/style-index": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = globalThis["webpackChunknihi"] = globalThis["webpackChunknihi"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["side-by-side-image-video-container/style-index"], () => (__webpack_require__("./src/side-by-side-image-video-container/index.js")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=index.js.map