<?php
$id = 'villas-list' . $block['id'];
?>
<?php
if (isset($block['data']['preview_image_help'])) : /* rendering in inserter preview */ ?>
<?php
    echo '<img src="' . plugin_dir_url(__FILE__) . $block['data']['preview_image_help'] . '" style="width:100%; height:auto;">';

else : /* rendering in editor body */
?>

    <section class="container villas-have-fun" data-comp="villas-have-fun">
        <section class="container">
            <div class="row top villas-have-fun__row">
                <?php
                $Villas = get_posts(array(
                    'posts_per_page'   => -1,
                    // 'orderby'          => 'menu_order',
                    'order'            => 'ASC',
                    'post_type'        => 'villas',
                    'post_status' => 'publish'
                ));
                foreach ($Villas as $villa) {
                    $show_villa = get_field('show_villa', $villa);
                    if ($show_villa) {
                        ?>
                        <article class="villas-have-fun__item <?= get_field('cards_size', $villa); ?> <?= get_field('desktop_position', $villa); ?> <?= get_field('mobile_position', $villa); ?>">
                            <?php
                            if (is_admin()) {
                            ?>
                                <a rel="noopener">
                                <?php
                            } else {
                                ?>
                                    <a href="<?= get_permalink($villa); ?>">
                                    <?php
                                }
                                if (get_field('video', $villa)) {
                                    ?>
                                        <figure class="img-box">
                                            <video playsinline autoplay loop muted data-type="autoplay" src="<?= get_field('video', $villa); ?>">
                                            </video>
                                        </figure>
                                    <?php
                                } elseif (get_field('card_image', $villa) || get_field('card_image_mobile', $villa)) {
                                    ?>
                                        <picture class="img-box">
                                            <?php
                                            if (get_field('card_image', $villa)) {
                                            ?>
                                                <source media="(min-width: 961px)" srcset="<?= wp_get_attachment_image_url(get_field('card_image', $villa), 'full'); ?>" />
                                            <?php
                                            }
                                            if (get_field('card_image_mobile', $villa)) {
                                            ?>
                                                <source media="(max-width: 960px) and (-webkit-min-device-pixel-ratio: 2)" srcset="<?= wp_get_attachment_image_url(get_field('card_image_mobile', $villa), 'full'); ?>" />
                                            <?php
                                            }
                                            echo wp_get_attachment_image(get_field('card_image', $villa), 'full');
                                            ?>
                                        </picture>
                                    <?php
                                }
                                    ?>
                                    <div class="description">
                                        <h3><?= $villa->post_title; ?></h3>
                                        <?php
                                        $list = explode(PHP_EOL, get_field('information', $villa));

                                        if ($list && is_array($list)) {
                                            echo '<ul>';
                                            foreach ($list as $item) {
                                        ?>
                                                <li><?= $item; ?></li>
                                        <?php
                                            }
                                            echo '</ul>';
                                        }
                                        ?>
                                        <span class="text-mobile mobile">Explore</span>
                                    </div>
                                    </a>
                        </article>
                        <?php
                    }
                }
                ?>
            </div>
        </section>
    </section>
    <nav class="container have-fun-filter" data-comp="have-fun-filter">
        <div class="row">
            <div class="col-12-12 center">
                <div class="have-fun-filter__wrapper">
                    <!-- List -->
                    <?php
                    $Categories = get_terms(array(
                        'taxonomy' => 'villas_type',
                        'hide_empty' => false,
                    ));
                    ?>
                    <ul class="have-fun-filter__list">
                        <?php
                        if ($Categories) {
                            foreach ($Categories as $category) {
                        ?>
                                <li><a href="<?= get_category_link($category); ?>"><?= $category->name; ?></a></li>
                        <?php
                            }
                        }
                        ?>
                    </ul>
                    <!-- Select -->
                    <div class="have-fun-filter__select">
                        <button>choose category</button>
                    </div>
                    <!-- Close -->
                    <i class="have-fun-filter__icon-close">close</i>
                </div>
            </div>
        </div>
    </nav>
<?php endif; ?>
<!-- /Have fun filter -->