<?php
defined('ABSPATH') || exit;

function nihi_map_and_title_load_textdomain()
{
    load_plugin_textdomain('nihi', false, basename(__DIR__) . '/languages');
}
add_action('init', 'nihi_map_and_title_load_textdomain');

function map_and_title_block_init()
{

    register_block_type(__DIR__.'/../build/map-and-title');

    if (function_exists('wp_set_script_translations')) {
        wp_set_script_translations('nihi_map_and_title', 'nihi');
    }
}

function getLocations($Data) {

    $Locations = array();

    foreach ($Data as $location) {

        if($location->post_status == 'publish'){

            $main = get_field('is_featured', $location);

            $location = wp_parse_args($location, array(
                'name' => $location->post_title,
                'location' => get_field('location', $location),
                'description' => get_field('description', $location),
                'lat_long' => str_replace(' ', '', trim(get_field('lat_long', $location))),
                'image' => get_field('svg', $location),
                'main' => $main ,
                'position' => get_field('position', $location),
                'useAdvancedMarker' => false,
                'pin' => get_field('map_pin', $location),
                'pin_hover' => get_field('map_pin', $location),
                'pin_width' => $main  ? '35' : '25',
                'pin_height' => $main  ? '35' : '25',
            ));
    
            $Locations[] = $location;
        }


    }

    return $Locations;
}

add_action('init', 'map_and_title_block_init');
