<?php
/**
 * Plugin Name:       Nihi Core
 * Plugin URI:		  https://big.partners/
 * Description:       Core plugin
 * Requires at least: 6.1
 * Requires PHP:      7.0
 * Version:           1.0.0
 * Author:            BIG Partners
 * Author URI:        https://big.partners/
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       nihi
 *
 */

defined( 'ABSPATH' ) || exit;

add_action('enqueue_block_editor_assets', 'nihi_enqueue');
add_action( 'wp_print_styles', 'nihi_enqueue' );

function nihi_enqueue(){
wp_register_style( 'reset', get_template_directory_uri() . '/css/libraries/reset.css' );
wp_register_style( 'grid', get_template_directory_uri() . '/css/libraries/grid.css' );
wp_register_style( 'splide', get_template_directory_uri() . '/css/libraries/splide.min.css' ); 
wp_register_style( 'main', get_template_directory_uri() . '/css/main.css' );
wp_enqueue_style( 'reset' );
wp_enqueue_style( 'grid' );
wp_enqueue_style( 'splide' );
wp_enqueue_style( 'main' );
}

function nihi_block_categories( $categories, $editor_context ) {
return array_merge(
    array(
        array(
            'slug'  => 'nihi-blocks',
            'title' => 'Nihi Blocks',
            'icon'  => 'dashicons-feedback'
        ),
    ),
    $categories
);
}
add_filter( 'block_categories_all', 'nihi_block_categories', 10, 2 );


// @accordions
require plugin_dir_path( __FILE__ ) . 'inc/accordion-tabs.php';
require plugin_dir_path( __FILE__ ) . 'inc/accordion-complex.php';
require plugin_dir_path( __FILE__ ) . 'inc/accordion-complex-item.php';
require plugin_dir_path( __FILE__ ) . 'inc/accordion-simple.php';
require plugin_dir_path( __FILE__ ) . 'inc/accordion-simple-item.php';
require plugin_dir_path( __FILE__ ) . 'inc/accordion-two-columns.php';
// @end
//require plugin_dir_path( __FILE__ ) . 'inc/have-fun-categories-crosselling.php';
require plugin_dir_path( __FILE__ ) . 'inc/have-fun-activities-crosselling.php';
require plugin_dir_path( __FILE__ ) . 'inc/have-fun-activities-crosselling-item.php';
require plugin_dir_path( __FILE__ ) . 'inc/gallery-of-three-videos.php';
require plugin_dir_path( __FILE__ ) . 'inc/full-text-section.php';
require plugin_dir_path( __FILE__ ) . 'inc/text-in-botton-header.php';
//require plugin_dir_path( __FILE__ ) . 'inc/imgs-overlapping-text.php';
require plugin_dir_path( __FILE__ ) . 'inc/video-with-cover-text-with-controls-and-audio.php';
require plugin_dir_path( __FILE__ ) . 'inc/small-and-macro-text-with-button.php';
//require plugin_dir_path( __FILE__ ) . 'inc/small-and-macro-text-without-button.php';
require plugin_dir_path( __FILE__ ) . 'inc/floorplans-gallery.php';
require plugin_dir_path( __FILE__ ) . 'inc/floorplans-gallery-item.php';
require plugin_dir_path( __FILE__ ) . 'inc/form-contact-details.php';
require plugin_dir_path( __FILE__ ) . 'inc/booking-form.php';
require plugin_dir_path( __FILE__ ) . 'inc/map-and-title.php';
require plugin_dir_path( __FILE__ ) . 'inc/paragraph-for-prices-or-announcements.php';
require plugin_dir_path( __FILE__ ) . 'inc/video-with-image-or-graphic-detail-overlap.php';
require plugin_dir_path( __FILE__ ) . 'inc/banner-with-graphic-overlap.php';
//require plugin_dir_path( __FILE__ ) . 'inc/have-fun-thumbnail.php';
//require plugin_dir_path( __FILE__ ) . 'inc/have-fun-thumbnail-item.php';
require plugin_dir_path( __FILE__ ) . 'inc/side-by-side-image-video-container.php';
require plugin_dir_path( __FILE__ ) . 'inc/image-gallery.php';
require plugin_dir_path( __FILE__ ) . 'inc/image-gallery-item.php';
require plugin_dir_path( __FILE__ ) . 'inc/header-supports-video-or-images.php';
require plugin_dir_path( __FILE__ ) . 'inc/icon-horizontal-slider.php';
require plugin_dir_path( __FILE__ ) . 'inc/icon-horizontal-slider-item.php';
require plugin_dir_path( __FILE__ ) . 'inc/header-mosaico-parallax.php';
require plugin_dir_path( __FILE__ ) . 'inc/three-image-lightbox.php';
require plugin_dir_path( __FILE__ ) . 'inc/header-with-title.php';
require plugin_dir_path( __FILE__ ) . 'inc/slider-header-autoplay.php';
require plugin_dir_path( __FILE__ ) . 'inc/slider-header-autoplay-item.php';
require plugin_dir_path( __FILE__ ) . 'inc/spacer-block.php';
// @villas
require plugin_dir_path( __FILE__ ) . 'inc/villas-showcase.php';
require plugin_dir_path( __FILE__ ) . 'inc/villas-list.php';
//require plugin_dir_path( __FILE__ ) . 'inc/villas-list-item.php';
// @posts list
require plugin_dir_path( __FILE__ ) . 'inc/excursions-list.php';
require plugin_dir_path( __FILE__ ) . 'inc/blog-list.php';
require plugin_dir_path( __FILE__ ) . 'inc/related-blog-list.php';
require plugin_dir_path( __FILE__ ) . 'inc/wellness-list.php';
// ACF TEST 
require plugin_dir_path( __FILE__ ) . 'inc/villas-information.php';
require plugin_dir_path(__FILE__) . 'inc/rates.php';
// @end

// RICH TEXT FORMATS
require plugin_dir_path(__FILE__) . 'inc/rich-text-formats.php';

