/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { InnerBlocks, RichText, useBlockProps } from "@wordpress/block-editor";

/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
export default function save(props) {
	const { attributes } = props;

	return (
		<article
			{...useBlockProps.save()}
			className="offset-left-12-1 col-12-10 accordion"
		>
			<header>
				<RichText.Content tagName="h4" value={attributes.summary} />
				<div>
					<i className="icon"></i>
				</div>
			</header>
			<div className="content-wrapper">
				<div className="">
					<RichText.Content tagName="h5" value={attributes.title} />
				</div>
				<div className="row-wrapper">
					<div className="main">
						<RichText.Content tagName="p" value={attributes.content} />
					</div>
					<aside>
						<InnerBlocks.Content />
						<RichText.Content
							className="capacity"
							tagName="strong"
							value={attributes.capacity}
						/>
					</aside>
				</div>
			</div>
		</article>
	);
}
