import memoize from "memize";
import times from "lodash/times";

import { __ } from "@wordpress/i18n";

import {
	InnerBlocks,
	RichText,
	useBlockProps,
	InspectorControls,
} from "@wordpress/block-editor";
import {
	Button,
	TabPanel,
	PanelBody,
	ToggleControl,
	Panel,
	PanelRow,
} from "@wordpress/components";

import "./editor.scss";

const ALLOWED_BLOCKS = ["nihi/accordion-complex-item"];

const getCount = memoize((count) => {
	return times(count, () => ["nihi/accordion-complex-item"]);
});

export default function Edit({ attributes, setAttributes }) {
	const { heading, description, overview, count, firstOpen } = attributes;

	return (
		<>
			<InspectorControls key="setting">
				<Panel className="components-panel--custom">
					<PanelRow>
						<ToggleControl
							label="First accordion open on default?"
							help={firstOpen ? "Open on default" : "Closed on default"}
							checked={firstOpen}
							onChange={(firstOpen) => {
								setAttributes({ firstOpen });
							}}
						/>
					</PanelRow>
				</Panel>
			</InspectorControls>
			<div {...useBlockProps()}>
				<section className="accordion-complex" data-comp="accordion-complex">
					<header className="row">
						<RichText
							tagName="h2"
							value={heading}
							className="col-12-8 offset-left-12-2 center"
							onChange={(newHeading) => setAttributes({ heading: newHeading })}
							placeholder="Heading"
						/>
						<RichText
							tagName="p"
							value={description}
							className="col-12-8 offset-left-12-2 center"
							onChange={(newDescription) =>
								setAttributes({ description: newDescription })
							}
							placeholder="Description"
						/>
						<RichText
							tagName="h3"
							value={overview}
							className="col-12-8 offset-left-12-2 no-mobile"
							onChange={(newOverview) =>
								setAttributes({ overview: newOverview })
							}
							placeholder="Overview"
						/>
					</header>
					<div className="row">
						<InnerBlocks
							__experimentalCaptureToolbars={true}
							allowedBlocks={ALLOWED_BLOCKS}
							template={getCount(count)}
						/>
					</div>
				</section>
			</div>
		</>
	);
}
