/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { InnerBlocks, useBlockProps, RichText } from "@wordpress/block-editor";

/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
export default function save(props) {
	const { attributes } = props;

	return (
		<section
			{...useBlockProps.save()}
			className={`accordion-complex ${attributes.firstOpen ? 'first-open' : ''}`}
			data-comp="accordion-complex"
		>
			<header className="row">
				{attributes.heading ? (
					<RichText.Content
						className="col-12-8 offset-left-12-1 center"
						tagName="h2"
						value={attributes.heading}
					/>
				) : (
					""
				)}
				{attributes.description ? (
					<RichText.Content
						className="col-12-8 offset-left-12-1 center"
						tagName="p"
						value={attributes.heading}
					/>
				) : (
					""
				)}
				{attributes.overview ? (
					<RichText.Content
						className="col-12-8 offset-left-12-1"
						tagName="h3"
						value={attributes.overview}
					/>
				) : (
					""
				)}
			</header>
			<div className="row">
				<InnerBlocks.Content />
			</div>
		</section>
	);
}
