import { __ } from '@wordpress/i18n';

import { RichText, useBlockProps, createBlock } from '@wordpress/block-editor';

export default [{
    attributes: {
        title: {
            type: 'string',
        }
    },
    save({ attributes }) {
      return (
            <article {...useBlockProps.save()} className="col-12-12 accordion">
            <header>
                {attributes.title && (
                <RichText.Content tagName="h4" value={attributes.title} />
                )}
                <div>
                <i className="icon-arrow-left"></i>
                </div>
            </header>
            <div className="content-wrapper">
                <RichText.Content tagName="p" value={attributes.content} />
            </div>
            </article>
        );
    },
    migrate(attributes) {
        const newInnerBlocks = [createBlock('core/paragraph', { content: attributes.content })];
        return [attributes, newInnerBlocks];
    },
}];
