
import { __ } from '@wordpress/i18n';

import { InnerBlocks, RichText, useBlockProps } from '@wordpress/block-editor';

import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { title, content } = attributes;

	return (
		<article {...useBlockProps()} className="col-12-12 accordion active block-editor-block-list__block wp-block">
			<header>
				<RichText
					tagName="h4"
					value={title}
					onChange={(newTitle) => setAttributes({ title: newTitle })}
					placeholder="Title"
				/>
				<div>
					<i className="icon-arrow-left"></i>
				</div>
			</header>
			<div className="content-wrapper">
				<InnerBlocks
					__experimentalCaptureToolbars={true}
					template={[
						['core/paragraph', {content: content}]
					]}
				/>
			</div>
		</article>	
	);
}
