import memoize from "memize";
import times from "lodash/times";
import { __ } from "@wordpress/i18n";
import { InnerBlocks, RichText, useBlockProps, InspectorControls } from "@wordpress/block-editor";
import {
	ToggleControl,
	Panel,
	PanelRow,
} from "@wordpress/components";

import "./editor.scss";

import preview from './assets/accordion-simple.jpg';

const ALLOWED_BLOCKS = ["nihi/accordion-simple-item"];

const getCount = memoize((count) => {
	return times(count, () => ["nihi/accordion-simple-item"]);
});

export default function Edit({ attributes, setAttributes }) {
	const { title, description, count, firstOpen } = attributes;

	return (
		<>
			<InspectorControls key="setting">
				<Panel className="components-panel--custom">
					<PanelRow>
						<ToggleControl
							label="First accordion open on default?"
							help={firstOpen ? "Open on default" : "Closed on default"}
							checked={firstOpen}
							onChange={(firstOpen) => {
								setAttributes({ firstOpen });
							}}
						/>
					</PanelRow>
				</Panel>
			</InspectorControls>
			<div {...useBlockProps()}>
				<section className='accordion-simple' data-comp="accordion-simple" data-preview="true">

					<figure className="preview">
						<img src={preview} alt="" />
					</figure>
					
					<header className="row">
						<RichText
							tagName="h2"
							value={title}
							className="col-12-12"
							onChange={(newTitle) => setAttributes({ title: newTitle })}
							placeholder="Title"
						/>
						<RichText
							tagName="h3"
							value={description}
							className="col-12-12"
							onChange={(newDescription) =>
								setAttributes({ description: newDescription })
							}
							placeholder="Description"
						/>
					</header>
					<div className="row">
						<InnerBlocks
							__experimentalCaptureToolbars={true}
							allowedBlocks={ALLOWED_BLOCKS}
							template={getCount(count)}
						/>
					</div>
				</section>
			</div>
		</>
	);
}
