/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
import { registerBlockType } from '@wordpress/blocks';

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */
import './style.scss';

/**
 * Internal dependencies
 */
import Edit from './edit';
import save from './save';
import metadata from './block.json';

/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
registerBlockType( metadata.name, {
	icon: {
		src: <svg id="Capa_1" data-name="Capa 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 81 81"><defs><style>.cls-1{"fill:#000;stroke-width:0px;"}</style></defs><path className="cls-1" d="M8.83,30h63.5c.83,0,1.5-.67,1.5-1.5s-.67-1.5-1.5-1.5H8.83c-.83,0-1.5.67-1.5,1.5s.67,1.5,1.5,1.5Z"/><path className="cls-1" d="M8.83,16h63.5c.83,0,1.5-.67,1.5-1.5s-.67-1.5-1.5-1.5H8.83c-.83,0-1.5.67-1.5,1.5s.67,1.5,1.5,1.5Z"/><path className="cls-1" d="M62.83,43.22H13.33c-.83,0-1.5.67-1.5,1.5s.67,1.5,1.5,1.5h49.5c.83,0,1.5-.67,1.5-1.5s-.67-1.5-1.5-1.5Z"/><path className="cls-1" d="M13.33,52.22h39c.83,0,1.5-.67,1.5-1.5s-.67-1.5-1.5-1.5H13.33c-.83,0-1.5.67-1.5,1.5s.67,1.5,1.5,1.5Z"/><path className="cls-1" d="M62.83,55.22H13.33c-.83,0-1.5.67-1.5,1.5s.67,1.5,1.5,1.5h49.5c.83,0,1.5-.67,1.5-1.5s-.67-1.5-1.5-1.5Z"/><path className="cls-1" d="M70.44,35H10.56c-2.42,0-4.4,1.97-4.4,4.4v24.2c0,2.43,1.97,4.4,4.4,4.4h59.87c2.42,0,4.4-1.97,4.4-4.4v-24.2c0-2.42-1.97-4.4-4.4-4.4ZM71.83,63.6c0,.77-.63,1.4-1.4,1.4H10.56c-.77,0-1.4-.63-1.4-1.4v-24.2c0-.77.63-1.4,1.4-1.4h59.87c.77,0,1.4.63,1.4,1.4v24.2Z"/><path className="cls-1" d="M71.39,18.42c-.59-.59-1.54-.59-2.12,0h0s0,0,0,0l-3.06,3.06-3.06-3.06c-.59-.58-1.53-.59-2.12,0-.59.59-.58,1.54,0,2.12l4.11,4.11s0,0,0,0c.29.29.68.44,1.06.44s.77-.15,1.06-.44h0s0,0,0,0l3.09-3.09,1.03-1.03h0s0,0,0,0c.59-.59.59-1.54,0-2.12Z"/></svg>
	},
	/**
	 * @see ./edit.js
	 */
	edit: Edit,

	/**
	 * @see ./save.js
	 */
	save,
} );
