import { InnerBlocks, useBlockProps, RichText } from "@wordpress/block-editor";

export default function save(props) {
	const { attributes } = props;

	return (
		<section
			{...useBlockProps.save()}
            className={`accordion-simple ${attributes.firstOpen ? 'first-open' : ''}`} 
			data-comp="accordion-simple"
		>
			<header className="row">
				{attributes.title && (
					<RichText.Content
						tagName="h2"
						value={attributes.title}
						className="col-12-12"
					/>
				)}
                {attributes.description && (
					<RichText.Content
						tagName="h3"
						value={attributes.description}
						className="col-12-12"
					/>
				)}
			</header>
			<div className="row">
				<InnerBlocks.Content />
			</div>
		</section>
	);
}
