import { __ } from "@wordpress/i18n";

import { RichText, useBlockProps } from "@wordpress/block-editor";

export default [
	{
		attributes: {
			heading: {
				type: "string",
				default: "",
			},
			firstOpen: {
				type: "boolean",
				default: false,
			},
			tabs: {
				type: "array",
				default: [],
				items: {
					type: "object",
					default: {
						name: {
							type: "string",
							default: "",
						},
						faqs: {
							type: "array",
							default: [],
							items: {
								type: "object",
								default: {
									title: {
										type: "string",
										default: "",
									},
									faq: {
										type: "string",
										default: "",
									},
								},
							},
						},
					},
				},
			},
		},
		save(props) {
			const { attributes } = props;
			return (
				<section
					{...useBlockProps.save()}
					className="accordion-tabs"
					data-comp="accordion-tabs"
				>
					<header className="row no-mobile">
						{attributes.heading && (
							<RichText.Content
								tagName="h2"
								className="col-12-12"
								value={attributes.heading}
							/>
						)}
					</header>
					<menu className="row">
						<ul className="tabs no-mobile col-12-12">
							{attributes.tabs.map((tab, i) => (
								<li key={i}>
									{
										<RichText.Content
											tagName="button"
											className="tab"
											data-tab={i}
											value={tab.title}
										/>
									}
								</li>
							))}
						</ul>
					</menu>
					{attributes.tabs.map((tab, i) => (
						<div className="row group" data-tab={i} key={i}>
							<header>
								{tab.title && (
									<RichText.Content
										tagName="h3"
										className="mobile"
										value={tab.title}
									/>
								)}
							</header>
							{tab.faqs.map((faq, i) => (
								<article
									className={`col-12-12 accordion ${
										attributes.firstOpen && i === 0 ? "active" : ""
									}`}
									key={i}
								>
									<header>
										{faq.title && (
											<RichText.Content tagName="h4" value={faq.title} />
										)}
										<div>
											<i class="icon-arrow-left"></i>
										</div>
									</header>
									<div className="content-wrapper">
										{faq.faq && (
											<RichText.Content tagName="p" value={faq.faq} />
										)}
									</div>
								</article>
							))}
						</div>
					))}
				</section>
			);
		},
	},
];
