/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
import { registerBlockType } from "@wordpress/blocks";

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */
import "./style.scss";

/**
 * Internal dependencies
 */
import Edit from "./edit";
import save from "./save";
import metadata from "./block.json";
import deprecated from "./deprecated";

/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
registerBlockType(metadata.name, {
	icon: {
		src: (
			<svg
				xmlns="http://www.w3.org/2000/svg"
				data-name="Capa 1"
				viewBox="0 0 81 81"
			>
				<path
					d="M9.7 18.4h15.6a3 3 0 0 1 3 3v2.8a3 3 0 0 1-3 3H9.7a3 3 0 0 1-3-3v-2.7a3 3 0 0 1 3-3m23 8.7h15.6a3 3 0 0 0 3-3v-2.7a3 3 0 0 0-3-3H32.7a3 3 0 0 0-3 3v2.7a3 3 0 0 0 3 3m0-5.8h15.6v2.8H32.7zm38.6-3H55.7a3 3 0 0 0-3 3v2.8a3 3 0 0 0 3 3h15.6a3 3 0 0 0 3-3v-2.7a3 3 0 0 0-3-3m0 5.8H55.7v-2.8h15.6zm1 21.3H8.8q-1.5 0-1.6 1.5.2 1.4 1.5 1.5h63.6q1.3-.1 1.5-1.5-.2-1.4-1.5-1.5m0-14H8.8a1.5 1.5 0 1 0 0 3h63.5a1.5 1.5 0 1 0 0-3m0 28H8.8a1.5 1.5 0 1 0 0 3h63.5a1.5 1.5 0 1 0 0-3m-1.9-22.5q-1-.9-2 0l-3.2 3-3-3a1.5 1.5 0 0 0-2.1 2.1l4 4.1q.6.5 1.1.5s.8-.2 1.1-.5l3-3 1.1-1q.9-1.2 0-2.2m0 14q-1-.9-2 0l-3.2 3.1-3-3a1.5 1.5 0 0 0-2.1 2l4 4.2q.6.4 1.1.4s.8-.1 1.1-.4l3-3.1 1.1-1q.9-1.1 0-2.2"
					class="prefix__cls-1"
				/>
			</svg>
		),
	},
	/**
	 * @see ./edit.js
	 */
	edit: Edit,

	/**
	 * @see ./save.js
	 */
	save,
	deprecated,
});
