import Mutimedia from "../../modules/Multimedia";
const { registerBlockType } = wp.blocks;

import { RichText, useBlockProps } from "@wordpress/block-editor";

registerBlockType("strathmore/content-fixed-child", {
	title: "Content fixed child",
	icon: "smiley",
	ancestor: ["strathmore/content-fixed-title"],
	category: "strathmore-blocks",
	attributes: {},

	edit: ({ attributes, setAttributes }) => {
		const { subtitle, title, text, number } = attributes;
		return (
			<li {...useBlockProps({ className: "splide__slide" })}>
				<aside>
					<RichText
						tagName="strong"
						value={number}
						className="jumbo-number"
						onChange={(number) => setAttributes({ number })}
						placeholder="0"
					/>
					<button class="mobile">
						<i class="icon-arrow-right-mobile circle fill"></i>
					</button>
				</aside>
				<article>
					<div class="content">
						<span class="head">
							<RichText
								tagName="small"
								value={subtitle}
								onChange={(subtitle) => setAttributes({ subtitle })}
								placeholder="Enter subtitle"
							/>
							<RichText
								tagName="h3"
								value={title}
								onChange={(title) => setAttributes({ title })}
								placeholder="Enter title"
							/>
						</span>
						<RichText
							tagName="p"
							value={text}
							onChange={(text) => setAttributes({ text })}
							placeholder="Enter content"
						/>
					</div>
					<figure class="img-box">
						<Mutimedia.edit
							{...{ attributes, setAttributes, name: "media" }}
							onlyImage
						/>
					</figure>
				</article>
			</li>
		);
	},

	save: ({ attributes }) => {
		const { subtitle, title, text, number, media } = attributes;
		return (
			<li {...useBlockProps.save({ className: "splide__slide" })}>
				<aside>
					<strong class="jumbo-number">
						{number && (
							<RichText.Content
								tagName="strong"
								value={number}
								className="jumbo-number"
							/>
						)}
					</strong>
					<button class="mobile">
						<i class="icon-arrow-right-mobile circle fill"></i>
					</button>
				</aside>
				<article>
					<div class="content">
						<span class="head">
							{subtitle && (
								<RichText.Content tagName="small" value={subtitle} />
							)}
							{title && <RichText.Content tagName="h3" value={title} />}
						</span>
						{text && <RichText.Content tagName="p" value={text} />}
					</div>
					<figure class="img-box">
						<Mutimedia.save value={media} />
					</figure>
				</article>
			</li>
		);
	},
});
