registerBlockType("strathmore/content-fixed-child", {
	title: "Content fixed child",
	icon: "smiley",
	ancestor: ["strathmore/content-fixed-title"],
	category: "strathmore-blocks",
	attributes: {
		subtitle: {
			type: "string",
		},
		title: {
			type: "string",
		},
		text: {
			type: "string",
		},
		number: {
			type: "string",
		},
		media: {
			type: "object",
		},
	},

	edit: ({ attributes, setAttributes }) => {
		const { title, content } = attributes;
		return (
			<>
				<RichText
					tagName="strong"
					value={attributes.title}
					onChange={(title) => setAttributes({ title })}
					placeholder="Title..."
				/>
				<RichText
					tagName="p"
					value={attributes.content}
					onChange={(newValue) =>
						updateAsideValue(newValue, currentEdit, "content", k)
					}
					placeholder="Content..."
				/>
			</>
		);
	},

	save: ({ attributes }) => {
		const { subtitle, title, text, number, media } = attributes;
		return (
			<li {...useBlockProps.save({ className: "splide__slide" })}>
				<aside>
					<strong class="jumbo-number">
						{number && (
							<RichText.Content
								tagName="strong"
								value={number}
								className="jumbo-number"
							/>
						)}
					</strong>
					<button class="mobile">
						<i class="icon-arrow-right-mobile circle fill"></i>
					</button>
				</aside>
				<article>
					<div class="content">
						<span class="head">
							{subtitle && (
								<RichText.Content tagName="small" value={subtitle} />
							)}
							{title && <RichText.Content tagName="h3" value={title} />}
						</span>
						{text && <RichText.Content tagName="p" value={text} />}
					</div>
					<figure class="img-box">
						<Mutimedia.save value={media} />
					</figure>
				</article>
			</li>
		);
	},
});
