const v1 = {
	attributes: {
		firstOpen: {
			type: "boolean",
			default: false,
		},
		title: {
			type: "string",
			default: "",
		},
		subtitle: {
			type: "string",
			default: "",
		},
		tabs: {
			type: "array",
			default: [],
			items: {
				type: "object",
				default: {
					name: {
						type: "string",
						default: "",
					},
					overview: {
						type: "string",
						default: "",
					},
					description: {
						type: "string",
						default: "",
					},
					asidetitle: {
						type: "string",
						default: "",
					},
					aside: {
						type: "array",
						default: [],
						items: {
							type: "object",
							default: {
								title: {
									type: "string",
									default: "",
								},
								content: {
									type: "string",
									default: "",
								},
							},
						},
					},
				},
			},
		},
	},
	migrate(attributes) {
		const { tabs, ...restAttributes } = attributes;

		const innerBlocks = tabs.map((tab, tabIndex) => ({
			name: "my-plugin/tab", // Define the inner block name
			attributes: {
				name: tab.name,
				overview: tab.overview,
				description: tab.description,
				asidetitle: tab.asidetitle,
				aside: tab.aside,
			},
			innerBlocks: tab.aside.map((asideItem) => [
				createBlock("core/paragraph", { content: asideItem.content }),
			]),
		}));

		return {
			...restAttributes,
			innerBlocks,
		};
	},
	save: function save(props) {
		const { attributes } = props;

		return (
			<section
				{...useBlockProps.save()}
				className={`accordion-two-columns ${
					attributes.firstOpen ? "first-open" : ""
				}`}
				data-comp="accordion-two-columns"
			>
				<div className="row top">
					<header className="offset-left-12-1 col-12-10">
						{attributes.title && (
							<RichText.Content
								tagName="h2"
								value={attributes.title}
								className="no-mobile"
							/>
						)}
						{attributes.subtitle && (
							<RichText.Content
								tagName="h3"
								value={attributes.subtitle}
								className="no-mobile"
							/>
						)}
					</header>
					<menu className="offset-left-12-1 col-12-5">
						<ul className="tabs no-mobile">
							{attributes.tabs.map((tab, k) => (
								<li
									className="tab"
									data-tab={k}
									key={k}
									role="button"
									aria-label="accordion toggle"
								>
									<header>
										{tab.name && (
											<RichText.Content
												tagName="h4"
												value={tab.name}
												className="no-mobile"
											/>
										)}
										<div>
											<i className="icon"></i>
										</div>
									</header>
								</li>
							))}
						</ul>
					</menu>
					<div className="aside-content col-12-6">
						{attributes.tabs.map((tab, k) => (
							<article className="accordion" key={k} data-tab={k}>
								<header className="mobile">
									{tab.name && (
										<RichText.Content tagName="h4" value={tab.name} />
									)}
									<div>
										<i className="icon"></i>
									</div>
								</header>
								<div className="content-wrapper">
									<div className="row-wrapper">
										<div className="main">
											{tab.overview && (
												<RichText.Content tagName="h5" value={tab.overview} />
											)}
											{tab.description && (
												<RichText.Content tagName="p" value={tab.description} />
											)}
										</div>
										<aside>
											{tab.asidetitle && (
												<RichText.Content tagName="h6" value={tab.asidetitle} />
											)}
											<ul>
												{tab.aside.map((elm, i) => (
													<li key={i}>
														{elm.title && (
															<RichText.Content
																tagName="strong"
																value={elm.title}
															/>
														)}
														{elm.content && (
															<RichText.Content
																tagName="p"
																value={elm.content}
															/>
														)}
													</li>
												))}
											</ul>
										</aside>
									</div>
								</div>
							</article>
						))}
					</div>
				</div>
			</section>
		);
	},
};

export const deprecated = [v1];
