// format.js
import { registerFormatType, toggleFormat } from "@wordpress/rich-text";
import { RichTextToolbarButton } from "@wordpress/block-editor";
import { Fragment } from "@wordpress/element";
import { __ } from "@wordpress/i18n";
import { ToolbarGroup } from "@wordpress/components";
import { applyFormat, removeFormat } from "@wordpress/rich-text";

const formatType = "my-plugin/custom-format";

const CustomFormatButton = ({ isActive, value, onChange }) => {
	return (
		<RichTextToolbarButton
			icon="editor-code"
			title={__("Custom Format", "my-plugin")}
			onClick={() => {
				onChange(
					isActive
						? removeFormat(value, formatType)
						: applyFormat(value, {
								type: formatType,
						  }),
				);
			}}
			isActive={isActive}
		/>
	);
};

