/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
import { registerBlockType } from "@wordpress/blocks";


/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * All files containing `style` keyword are bundled together. The code used
 * gets applied both to the front of your site and to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */
import "./style.scss";

/**
 * Internal dependencies
 */
import Edit from "./edit";
import save from "./save";
import metadata from "./block.json";

/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */

registerBlockType(metadata.name, {
	icon: {
		src: (
			<svg
				xmlns="http://www.w3.org/2000/svg"
				data-name="Capa 1"
				viewBox="0 0 81 81"
			>
				<path
					d="M68.8 34.4h-7.2a1.5 1.5 0 1 0 0 3h7.2a1.5 1.5 0 1 0 0-3m0 6h-7.2a1.5 1.5 0 1 0 0 3h7.2a1.5 1.5 0 1 0 0-3m-14.8-6H40.3a1.5 1.5 0 1 0 0 3H54a1.5 1.5 0 1 0 0-3m-13.7 9H49a1.5 1.5 0 1 0 0-3h-8.8a1.5 1.5 0 1 0 0 3m13.8 3H40.3a1.5 1.5 0 1 0 0 3H54a1.5 1.5 0 1 0 0-3"
					class="prefix__cls-1"
				/>
				<path
					d="M70.4 24.6H38c-2.4 0-4.4 2-4.4 4.4v23c0 2.4 2 4.4 4.4 4.4h32.2c2.5 0 4.4-2 4.4-4.4V29c0-2.4-2-4.4-4.4-4.4M71.6 52q-.1 1.2-1.4 1.4H38.1q-1.2-.2-1.4-1.4V29q.2-1.2 1.4-1.4h32.2q1.3.2 1.4 1.4zM30.3 25.4H7.8a1.5 1.5 0 1 0 0 3h22.5a1.5 1.5 0 1 0 0-3m0 16.6H7.8a1.5 1.5 0 1 0 0 3h22.5a1.5 1.5 0 1 0 0-3m0 7.6H7.8a1.5 1.5 0 1 0 0 3h22.5a1.5 1.5 0 1 0 0-3m-6.1-9.4 1 .4 1.2-.4 4-4.2q.5-.4.5-1 0-.8-.4-1l-4.2-4.2c-.5-.6-1.5-.6-2 0q-1 1 0 2.1l3 3-3 3.1c-.7.6-.7 1.6 0 2.2"
					class="prefix__cls-1"
				/>
			</svg>
		),
	},

	supports: {
		align: true,
		html: false,
	},
	/**
	 * @see ./edit.js
	 */
	edit: Edit,

	/**
	 * @see ./save.js
	 */
	save,
});
