import { __ } from "@wordpress/i18n";
import {
	RichText,
	useBlockProps,
	InspectorControls,
	MediaUpload,
} from "@wordpress/block-editor";
import {
	Panel,
	__experimentalDivider as Divider,
	Button,
	PanelBody,
	PanelRow,
	PanelControl,
} from "@wordpress/components";

import ResponsiveMedia from "./modules/ResponsiveMedia";
// import "./editor.scss";

export default function Edit({ attributes, setAttributes }) {
	const { title, responsiveBanner, responsiveFigure } = attributes;

	console.log({
		bool: !!String(responsiveFigure?.image),
		boolVideo: !!String(responsiveFigure?.video),
		responsiveFigure,
	});
	return (
		<>
			<InspectorControls key="setting">
				<Panel className="components-panel--custom">
					<ResponsiveMedia.control
						title="Banner"
						name="responsiveBanner"
						attribute={responsiveBanner}
						setAttributes={setAttributes}
					/>
					<ResponsiveMedia.control
						title="Graphic overlap"
						name="responsiveFigure"
						attribute={responsiveFigure}
						setAttributes={setAttributes}
					/>
				</Panel>
			</InspectorControls>

			<section
				{...useBlockProps()}
				className="container gutenberg-component banner-with-graphic-overlap block-editor-block-list__block wp-block"
				data-comp="banner-with-graphic-overlap"
			>
				<figure className="banner outer-video img-box">
					<ResponsiveMedia.edit attribute={responsiveBanner} />
					<figcaption>
						<RichText
							placeholder="Optional Title..."
							tagName="h2"
							value={title}
							className="after-icon"
							onChange={(newtitle) => setAttributes({ title: newtitle })}
						/>
					</figcaption>
				</figure>
				<div className="row">
					<aside className="col-12-5">
						<figure className="outer-article img-box">
							<ResponsiveMedia.edit attribute={responsiveFigure} />
						</figure>
					</aside>
				</div>
			</section>
		</>
	);
}
