import { MediaUpload } from "@wordpress/block-editor";
import { Button, PanelBody, PanelRow, Divider } from "@wordpress/components";

export default {
	control: (title, name, attribute, setAttributes) => {
		const { image, video } = attribute;
		return (
			<PanelBody title={`${title} Responsive Image`}>
				<PanelRow>
					<h2>Image Desktop</h2>
				</PanelRow>
				<PanelRow>
					<MediaUpload
						allowedTypes={["image"]}
						onSelect={(media) => {
							setAttributes({
								[name]: {
									...attribute,
									image: { ...image, desktop: media.url },
								},
							});
						}}
						multiple={false}
						render={({ open }) => (
							<>
								{image.desktop ? <img src={image.desktop} /> : ""}
								<Button variant="primary" onClick={open}>
									{image.desktop === null
										? "Select media file"
										: "Select Desktop"}
								</Button>
							</>
						)}
					/>
				</PanelRow>

				<Divider />

				<PanelRow>
					<h2>Image Mobile</h2>
				</PanelRow>
				<PanelRow>
					<MediaUpload
						allowedTypes={["image"]}
						onSelect={(media) => {
							setAttributes({
								[name]: {
									...attribute,
									image: { ...image, mobile: media.url },
								},
							});
						}}
						multiple={false}
						render={({ open }) => (
							<>
								{image.mobile ? <img src={image.mobile} /> : ""}
								<Button variant="primary" onClick={open}>
									{image.mobile === null
										? "Select media file"
										: "Select Mobile"}
								</Button>
							</>
						)}
					/>
				</PanelRow>

				<Divider />

				<PanelRow>
					<h2>Video</h2>
				</PanelRow>
				<PanelRow>
					<MediaUpload
						allowedTypes={["video"]}
						onSelect={(media) => {
							setAttributes({ [name]: { ...attribute, video: media.url } });
						}}
						multiple={false}
						render={({ open }) => (
							<>
								{video ? (
									<video
										autoPlay
										loop
										muted
										data-type="autoplay"
										src={video}
									></video>
								) : (
									""
								)}
								<Button variant="primary" onClick={open}>
									{video === null ? "Select media file" : "Select video"}
								</Button>
							</>
						)}
					/>
				</PanelRow>
			</PanelBody>
		);
	},
	view: (attribute) => {
		const { image, video } = attribute;
		return (
			<>
				{image?.desktop || image?.mobile ? (
					<picture class="img-box" style={{ with: "100%", heigth: "100%" }}>
						{image.desktop && (
							<source media="(min-width: 961px)" srcset={image.desktop} />
						)}
						{image.mobile && (
							<source media="(min-width: 961px)" srcset={image.mobile} />
						)}
						<img src={image.mobile || image.desktop} alt="" />
					</picture>
				) : (
					""
				)}
				{video && (
					<video autoPlay loop muted data-type="autoplay" src={video}></video>
				)}
			</>
		);
	},
	edit: (attribute) => {
		const { image, video } = attribute;
		return (
			<>
				{image?.desktop || image?.mobile ? (
					<picture class="img-box" style={{ with: "100%", heigth: "100%" }}>
						{image.desktop && (
							<source media="(min-width: 961px)" srcset={image.desktop} />
						)}
						{image.mobile && (
							<source media="(min-width: 961px)" srcset={image.mobile} />
						)}
						<img src={image.mobile || image.desktop} alt="" />
					</picture>
				) : (
					""
				)}
				{video && (
					<video autoPlay loop muted data-type="autoplay" src={video}></video>
				)}
			</>
		);
	},
};
