import {
	MediaUpload,
	RichText,
	useBlockProps,
	InspectorControls,
} from "@wordpress/block-editor";
import {
	Button,
	Panel,
	PanelBody,
	PanelRow,
	Divider,
} from "@wordpress/components";

export default {
	control: (title, name, attribute, setAttributes) => {
		const { image, video } = attribute;
		return (
			<PanelBody title={`${title} Responsive Image`}>
				<PanelRow>
					<h2>Image Desktop</h2>
				</PanelRow>
				<PanelRow>
					<MediaUpload
						allowedTypes={["image"]}
						onSelect={(media) => {
							setAttributes({
								[name]: {
									...attribute,
									image: { ...image, desktop: media.url },
								},
							});
						}}
						multiple={false}
						render={({ open }) => (
							<>
								{image ? <img src={image} /> : ""}
								<Button variant="primary" onClick={open}>
									{image === null ? "Select media file" : "Select Desktop"}
								</Button>
							</>
						)}
					/>
				</PanelRow>

				<Divider />

				<PanelRow>
					<h2>Image Mobile</h2>
				</PanelRow>
				<PanelRow>
					<MediaUpload
						allowedTypes={["image"]}
						onSelect={(media) => {
							setAttributes({
								[name]: {
									...attribute,
									image: { ...image, mobile: media.url },
								},
							});
						}}
						multiple={false}
						render={({ open }) => (
							<>
								{image ? <img src={image} /> : ""}
								<Button variant="primary" onClick={open}>
									{image === null ? "Select media file" : "Select Mobile"}
								</Button>
							</>
						)}
					/>
				</PanelRow>

				<Divider />

				<PanelRow>
					<h2>Video</h2>
				</PanelRow>
				<PanelRow>
					<MediaUpload
						allowedTypes={["video"]}
						onSelect={(media) => {
							setAttributes({ [name]: { ...attribute, video: media.url } });
						}}
						multiple={false}
						render={({ open }) => (
							<>
								{video ? (
									<video
										autoPlay
										loop
										muted
										data-type="autoplay"
										src={video}
									></video>
								) : (
									""
								)}
								<Button variant="primary" onClick={open}>
									{video === null ? "Select media file" : "Select video"}
								</Button>
							</>
						)}
					/>
				</PanelRow>
			</PanelBody>
		);
	},
	render: (attribute, ContainerTag, containerClass) => {
		const { image, video } = attribute;
		<ContainerTag className={containerClass}>
			{image.desktop || image.mobile ? (
				<picture class="img-box" style={{ with: "100%", heigth: "100%" }}>
					<source media="(min-width: 961px)" srcset={attributes.image} />
					<source
						media="(max-width: 960px) and (-webkit-min-device-pixel-ratio: 2)"
						srcset={attributes.imageMobile}
					/>
					<img src={attributes.image || attributes.imageMobile} alt="" />
				</picture>
			) : (
				""
			)}
			{video && (
				<video autoPlay loop muted data-type="autoplay" src={video}></video>
			)}
		</ContainerTag>;
	},
};
