import { useBlockProps } from "@wordpress/block-editor";
import ResponsiveMedia from "./modules/ResponsiveMedia";
export default function save({ attributes }) {
	const { responsiveFigure, responsiveBanner, title } = attributes;

	return (
		<section
			{...useBlockProps.save()}
			className={`banner-with-graphic-overlap ${
				(attributes.video ? "has-video" : "",
				!!String(responsiveFigure?.image) || !!String(responsiveFigure?.video)
					? "has-overlap-image"
					: "")
			}`}
			data-comp="banner-with-graphic-overlap"
		>
			{attributes.video && (
				<div
					className="control-video control-video--top mobile"
					data-comp="control-video-mobile"
				>
					<button className="control-video__button">Sound on</button>
				</div>
			)}
			<figure className="banner outer-video img-box">
				<ResponsiveMedia.view attribute={responsiveBanner} />
				<figcaption>
					<h2>{title}</h2>
				</figcaption>
			</figure>
			{/* Preguntale a Miguel */}
			{(!!String(responsiveFigure?.image) ||
				!!String(responsiveFigure?.video)) && (
				<div className="row">
					<aside className="col-12-5">
						<figure className="outer-article img-box">
							<ResponsiveMedia.view attribute={responsiveFigure} />
						</figure>
					</aside>
				</div>
			)}
		</section>
	);
}
