import { __ } from '@wordpress/i18n';
import { RichText, useBlockProps, InnerBlocks } from '@wordpress/block-editor';
import './editor.scss';
import preview from './assets/booking-form.jpg';
export default function Edit({ attributes, setAttributes }) {
    const { title } = attributes;

    return (
        <section {...useBlockProps()} className="container booking-form block-editor-block-list__block wp-block" data-preview="true">

            <figure className="preview">
                <img src={preview} alt="" />
            </figure>

            <div className="row">
                <div className="col-12-12">
                    <RichText
                        tagName="h2"
                        value={title}
                        onChange={(newValue) => setAttributes({ title: newValue })}
                        placeholder="Title..."
                    />
                    <div className="col-form" id="booking-form">
                        <small>You don't need to add the script tag and the target of the form should be: "#booking-form"</small>
                        <InnerBlocks
                            allowedBlocks={[
                                "core/html",
                            ]}
                            template={[
                                ['core/html']
                            ]}
                        />
                    </div>
                </div>
            </div>
        </section>
    );
}


