<?php
$Excursions = get_field('excursions');
?>
<section class="container excursion-have-fun" data-comp="excursion-have-fun">
    <section class="container">
        <div class="row">
            <div class="col-12-12">
                <a href="#" class="arrow-down"><i class="icon-arrow-down"></i></a>
            </div>
        </div>
        <div class="row top excursion-have-fun__row">
            <?php
            if($Excursions){
                foreach($Excursions as $excursion){
                    ?>
                    <article class="excursion-have-fun__item <?= get_field('mobile_position', $excursion); ?>">
                        <a href="<?= get_permalink($excursion); ?>" >
                            <figure class="img-box">
                                <?= wp_get_attachment_image(get_field('card_image', $excursion), 'full'); ?>
                            </figure>
                            <div class="description">
                                <h3><?= $excursion->post_title; ?></h3>
                                <span class="text-mobile mobile">view</span>
                            </div>
                        </a>
                    </article>
                    <?php
                }
            }
            ?>
        </div>
    </section>
</section>

<nav class="container have-fun-filter" data-comp="have-fun-filter">
    <div class="row">
        <div class="col-12-12 center">
            <div class="have-fun-filter__wrapper">
                <!-- List -->
                <?php
                $Categories = get_terms( array(
                    'taxonomy' => 'excursions',
                    'hide_empty' => false,
                )); 
                ?>
                <ul class="have-fun-filter__list">
                    <?php
                    if($Categories){
                        foreach($Categories as $category){
                            ?>
                            <li><a href="<?= get_category_link($category); ?>"><?= $category->name; ?></a></li>
                            <?php
                        }
                    }
                    ?>
                </ul>
                <!-- Select -->
                <div class="have-fun-filter__select">
                    <button>choose category</button>
                </div>
                <!-- Close -->
                <i class="have-fun-filter__icon-close">close</i>
            </div>
        </div>
    </div>
</nav>
<!-- /Have fun filter -->

