// Edit.js del bloque hijo
import { __ } from "@wordpress/i18n";
import {
	MediaUpload,
	InnerBlocks,
	MediaUploadCheck,
	useBlockProps,
} from "@wordpress/block-editor";
import { Button } from "@wordpress/components";

import "./editor.scss";

export default function Edit({ attributes, setAttributes }) {
	const { image, mediaType, video } = attributes;

	return (
		<div
			{...useBlockProps()}
			className="splide__slide block-editor-block-list__block wp-block"
		>
			<figure className="img-box">
				<MediaUploadCheck>
					<MediaUpload
						allowedTypes={["image", "video"]}
						onSelect={(media) => {
							if (media.type === "image") {
								setAttributes({
									image: media.url,
									mediaType: "image",
									video: null,
								});
							} else if (media.type === "video") {
								setAttributes({
									video: media.url,
									mediaType: "video",
									image: null,
								});
							}
						}}
						multiple={false}
						render={({ open }) => (
							<>
								{image && mediaType === "image" ? (
									<>
										<img src={image} alt="Selected Image" />
										<Button
											className="bttn--danger"
											variant="danger"
											onClick={() =>
												setAttributes({
													image: null,
													mediaType: null,
													video: null,
												})
											}
										>
											Remove Image
										</Button>
									</>
								) : video && mediaType === "video" ? (
									<>
										<video controls playsInline>
											<source src={video} type="video/mp4" />
											Your browser does not support the video tag.
										</video>
										<Button
											className="bttn--danger"
											variant="danger"
											onClick={() =>
												setAttributes({
													video: null,
													mediaType: null,
													image: null,
												})
											}
										>
											Remove Video
										</Button>
									</>
								) : (
									<>
										<Button variant="primary" onClick={open}>
											Select Image or Video
										</Button>
										<span>Recomended size: 440x320 / SVG Format</span>
									</>
								)}
							</>
						)}
					/>
				</MediaUploadCheck>
			</figure>
			<div className="description">
				<InnerBlocks />
			</div>
		</div>
	);
}
