import { useBlockProps, InnerBlocks } from '@wordpress/block-editor';


export default function save({ attributes }) {
	const { image, mediaType, video } = attributes;

	return (
		<div {...useBlockProps.save()} className="splide__slide">
			<figure className="img-box">
				{mediaType === 'image' && <img src={image} alt="Selected Image" />}
				{mediaType === 'video' && (
					<video playsInline autoPlay loop muted >
						<source src={video} type="video/mp4" />
						Your browser does not support the video tag.
					</video>
				)}
			</figure>
			<div className="description">
				<InnerBlocks.Content />
			</div>
		</div>
	);
}