/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { InnerBlocks, useBlockProps } from '@wordpress/block-editor';

/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
export default function save(props) {
	const { attributes } = props;

	return (
		<section { ...useBlockProps.save() } className="container floorplans-gallery" data-comp="floorplans-gallery">
			<header className="row">
				<article className="col-12-11 offset-left-12-1"> 
					<h2>{ attributes.title }</h2>
				</article>
			</header>
			<section className="row">
				<div className="col-12-11 offset-left-12-1 splide-wrapper">
					<section className="splide" aria-label="Floorplans gallery slider">
						<div className="splide__track">
							<div className="splide__list">
								<InnerBlocks.Content />
							</div>
						</div>
					</section>
				</div>
			</section>
			<div className="floorplans-gallery__arrows">
				<button className="floorplans-gallery__arrow--prev" data-direction="next"><span>Prev</span> <i className="icon-arrow-left" role="img" aria-label="Icon arrow left"></i></button>
				<button className="floorplans-gallery__arrow--next" data-direction="prev"><span>Next</span> <i className="icon-arrow-right" role="img" aria-label="Icon arrow right"></i></button>
			</div>
		</section>
	);
}
