import { __ } from '@wordpress/i18n';
import { RichText, useBlockProps, InnerBlocks, } from '@wordpress/block-editor';
import './editor.scss';
import preview from './assets/form-contact-details.jpg';
export default function Edit({ attributes, setAttributes }) {
    const { title, asideTitle, asideContent, contactName, phone, email } = attributes;

    return (
        <section {...useBlockProps()} className="form-contact-details container block-editor-block-list__block wp-block" data-comp="form-contact-details" data-preview="true">

            <figure className="preview">
                <img src={preview} alt="" />
            </figure>

            <div className="row top">
                <header className="col-12-12">
                    <RichText
                        tagName="h2"
                        value={title}
                        onChange={(newValue) => setAttributes({ title: newValue })}
                        placeholder="Title..."
                    />
                </header>
                <article className="col-form" id="contact-details-form">
                    <small>You don't need to add the script tag and the target of the form should be: "#contact-details-form"</small>
                    <InnerBlocks
                        allowedBlocks={[
                            "core/html",
                        ]}
                        template={[
                            ['core/html']
                        ]}
                    />
                </article>
                <aside className="col-info">
                    <article>
                        <RichText
                            tagName="h3"
                            value={asideTitle}
                            onChange={(newValue) => setAttributes({ asideTitle: newValue })}
                            placeholder="Title..."
                        />
                        <RichText
                            tagName="p"
                            value={asideContent}
                            onChange={(newValue) => setAttributes({ asideContent: newValue })}
                            placeholder="Content..."
                        />
                    </article>

                    <article className="address-wrapper">
                        <RichText
                            tagName="h4"
                            value={contactName}
                            onChange={(newValue) => setAttributes({ contactName: newValue })}
                            placeholder="Name..."
                        />
                        <address>
                            <p>Email</p>
                            <a href="tel:+16467522278">+1 646 752 2278</a>
                        </address>
                    </article>
                </aside>
            </div>
        </section>
    );
}


