
import { RichText, useBlockProps, InnerBlocks } from '@wordpress/block-editor';
export default function save(props) {
	const { attributes } = props;

	return (
		<section {...useBlockProps.save()} className="form-contact-details container" data-comp="form-contact-details">
			<div className="row top">
				<header className="col-12-12">
					<RichText.Content tagName='h2' value={attributes.title} />
				</header>
				<article className="col-form" id="contact-details-form">
                    <script defer>
					    <InnerBlocks.Content />
                    </script>
				</article>
				<aside className="col-info">
					<article>
						<h3>{attributes.asideTitle}</h3>
						<p>{attributes.asideContent}</p>
					</article>

					<article className="address-wrapper">
						<RichText.Content tagName="h4" value={attributes.contactName} />
						<address>
							<p>Email</p>
							<a href="tel:+16467522278">+1 646 752 2278</a>
						</address>
					</article>
				</aside>
			</div>
		</section>
	);
}


