/**
 * Retrieves the translation of text.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-i18n/
 */
import { __ } from '@wordpress/i18n';

/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { InnerBlocks, useBlockProps } from '@wordpress/block-editor';

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * Those files can contain any CSS code that gets applied to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */
import './editor.scss';

import preview from './assets/full-text-section.jpg';

/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @return {Element} Element to render.
 */
export default function Edit({ attributes, setAttributes }) {
	const {  } = attributes;

	return (
		<section {...useBlockProps()} className="container full-text-section block-editor-block-list__block wp-block" data-preview="true">

			<figure className="preview">
				<img src={preview} alt="" />
			</figure>

			<div className="row">
				<div className="col-12-12 center">
					<InnerBlocks
						template={[
							['core/heading', { level: 3, placeholder: 'Title 1' }],
							['core/separator', { className: 'big' }],
							['core/separator', { className: 'small' }],
							['core/heading', { level: 2, placeholder: 'Title 2' }],
							['core/paragraph', { placeholder: 'Text' }],
							['core/list', { ordered: true, placeholder: 'Ordered List' }],
							['core/quote', { value: 'Quote Text' }],
							['core/pullquote', { value: 'Pullquote Text' }],
							['core/table', { value: 'Table' }],
							['core/details', { value: 'Details' }],
						]}
					/>
				</div>
			</div>
		</section>
	);
}
