import memoize from 'memize';
import times from 'lodash/times';
import { __ } from '@wordpress/i18n';
import { ButtonBlockAppender, InnerBlocks, store as blockEditorStore, useBlockProps, RichText } from '@wordpress/block-editor';

import './editor.scss';

const ALLOWED_BLOCKS = [ 'nihi/have-fun-activities-crosselling-item' ];
const getCount = memoize( ( count ) => {
	return times( count, () => ALLOWED_BLOCKS );
} );

const InnerBlockWithLimit = ( clientId, count ) => {
	const innerBlockCount = useSelect( ( select ) => select( blockEditorStore ).getBlock( clientId ).innerBlocks );

	const appenderToUse = () => {
		if ( innerBlockCount.length < 4 ) {
			return (
				<ButtonBlockAppender rootClientId={ clientId } />
			);
		} else {
			return false;
		}
	}

	return (
		<InnerBlocks
			__experimentalCaptureToolbars={ true }
			allowedBlocks={ ALLOWED_BLOCKS }
			template={ getCount( count ) }
			renderAppender={ () => appenderToUse() }
		/>
	)
}

export default function Edit({ attributes, setAttributes, clientId }) {
	const { title, count} = attributes;

	return (
		<section {...useBlockProps()} className="have-fun-activities-crosselling block-editor-block-list__block wp-block" data-comp="have-fun-activities-crosselling">
			<div className="row top">
				<InnerBlocks
					__experimentalCaptureToolbars={ true }
					allowedBlocks={ ALLOWED_BLOCKS }
					template={ getCount( count ) }
				/>
				{InnerBlockWithLimit(clientId, count)}
			</div>
			<div className="outer-text">
				<RichText
					tagName="h2"
					value={title}
					onChange={(newTitle) => setAttributes({ title: newTitle })}
					placeholder="Title..."
				/>
			</div>
		</section>
	);
}


