import { __ } from '@wordpress/i18n';
import { MediaUpload, RichText, useBlockProps } from '@wordpress/block-editor';
import { Button } from '@wordpress/components';

import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { image, video, text } = attributes;

	return (
		<a {...useBlockProps()} className="col-article block-editor-block-list__block wp-block" href="#">
			<div className="media">
				<figure className="img-box video">
					<MediaUpload
						onSelect={(media) => setAttributes({ video: media.url })}
						allowedTypes={['video']}
						value={video}
						render={({ open }) => (
							<>
								{video ? (
									<>
										<video playsInline autoPlay="" loop="" muted="" data-type="autoplay" src={video}></video>
										<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ video: null })}>
											Remove video
										</Button>
									</>
								) : (
									<Button variant="primary" onClick={open}>
										Select video
									</Button>
								)}
							</>
						)}
					/>
				</figure>
				<figure className="img-box image">
					<MediaUpload
						onSelect={(media) => setAttributes({ image: media.url })}
						allowedTypes={['image']}
						value={image}
						render={({ open }) => (
							<>
								{image ? (
									<>
										<img src={image} />
										<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ image: null })}>
											Remove image
										</Button>
									</>
								) : (
									<Button variant="primary" onClick={open}>
										Select image
									</Button>
								)}
							</>
						)}
					/>
				</figure>
			</div>
			<RichText
				tagName="h3"
				value={text}
				onChange={(newTitle) => setAttributes({ text: newTitle })}
				placeholder="Title..."
			/>
			<span className="text-mobile mobile">view</span>
		</a>
	);
}
