import { RichText, useBlockProps } from '@wordpress/block-editor';

export default function save({ attributes }) {

	return (
		<a {...useBlockProps.save()} className="col-article" rel="noopener" href={attributes.cta} target={attributes.ctaTarget ? '_blank' : '_self'}>
			<div className="media">
					{attributes.video && (	
						<figure className="img-box video" style={attributes.image ? '' : 'opacity:1'}>
							<video
								loop=""
								muted=""
								src={attributes.video}
							></video>
						</figure>
					)}
					{attributes.image && (
						<picture className="img-box image">
							<source media="(min-width: 961px)" srcset={attributes.image} />
							<source media="(max-width: 960px) and (-webkit-min-device-pixel-ratio: 2)" srcset={attributes.imageMobile} />
							<img src={attributes.image || attributes.imageMobile} alt="" />
						</picture>
					)}
			</div>
			{attributes.title && (
				<RichText.Content tagName="h3" value={attributes.title} />
			)}
			<span className="text-mobile mobile">explore</span>
		</a>
	);
}
