import { useBlockProps, InnerBlocks, RichText } from "@wordpress/block-editor";
export default function save(props) {
	const { attributes } = props;

	return (
		<section
			{...useBlockProps.save()}
			className="container have-fun-activities-crosselling"
			data-comp="have-fun-activities-crosselling"
		>
			<div className="row top">
				<InnerBlocks.Content />
			</div>
			<div className="outer-text">
				{attributes.title && (
					<RichText.Content tagName="h2" value={attributes.title} />
				)}
			</div>
		</section>
	);
}
