/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { useBlockProps } from '@wordpress/block-editor';

/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
export default function save(props) {
	const { attributes } = props;

	return (
		<a { ...useBlockProps.save() } rel="noopener" className="have-fun-thumbnail__article" href={attributes.cta} target={attributes.ctaTarget ? '_blank' : '_self'}>
			<figure className="img-box"> 
				{attributes.asset.type === 'video' ? (
					<video playsInline autoPlay loop muted data-type="autoplay" src={attributes.asset.url} />
				) : (
					<img src={attributes.asset.url} alt={attributes.asset.title} />
				)}
				<figcaption>
					<button><span>{ attributes.button }</span></button>
				</figcaption>
			</figure>
			<h3>{ attributes.title }</h3>
		</a>
	);
}
