import { __ } from '@wordpress/i18n';
import { MediaUpload, useBlockProps, RichText } from '@wordpress/block-editor';
import { Button } from '@wordpress/components';

import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { title, subtitle, text, imageOne, imageTwo, imageThree, imageFour, imageFive, imageSix } = attributes;

	return (
		<section {...useBlockProps()} className="header-mosaico-parallax block-editor-block-list__block wp-block" data-comp="header-mosaico-parallax">
			<div className="fixed-content">
				<RichText
					tagName="h2"
					value={title}
					onChange={(newTitle) => setAttributes({ title: newTitle })}
					placeholder="Title..."
				/>
			</div>
			<div className="header-mosaico-parallax__figures">
				<figure className="img-box header-mosaico-parallax__image">
					<MediaUpload
						onSelect={(media) => setAttributes({ imageOne: media.url })}
						allowedTypes={['image']}
						value={imageOne}
						render={({ open }) => (
							<>
								{imageOne ? (
									<>
										<div className='bg' style={{ backgroundImage: `url(${imageOne})` }}></div>
										<div className='outer-control'>
										<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageOne: null })}>
											Remove image
										</Button>
										</div>
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>
											Select image
										</Button>
										<span>Recomended size 830x716</span>
									</div>
								)}
							</>
						)}
					/>
				</figure>
				<figure className="img-box header-mosaico-parallax__image">
					<MediaUpload
						onSelect={(media) => setAttributes({ imageTwo: media.url })}
						allowedTypes={['image']}
						value={imageTwo}
						render={({ open }) => (
							<>
								{imageTwo ? (
									<>
										<div className='bg' style={{ backgroundImage: `url(${imageTwo})` }}></div>
										<div className='outer-control'>
										<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageTwo: null })}>
											Remove image
										</Button>
										</div>
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>
											Select image
										</Button>
										<span>Recomended size 480x628</span>
									</div>
								)}
							</>
						)}
					/>
				</figure>
				<figure className="img-box header-mosaico-parallax__image">
					<MediaUpload
						onSelect={(media) => setAttributes({ imageThree: media.url })}
						allowedTypes={['image']}
						value={imageThree}
						render={({ open }) => (
							<>
								{imageThree ? (
									<>
										<div className='bg' style={{ backgroundImage: `url(${imageThree})` }}></div>
										<div className='outer-control'>
											<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageThree: null })}>
												Remove image
											</Button>
										</div>
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>
											Select image
										</Button>
										<span>Recomended size 458x661</span>
									</div>
								)}
							</>
						)}
					/>
				</figure>
				<figure className="img-box header-mosaico-parallax__image">
					<MediaUpload
						onSelect={(media) => setAttributes({ imageFour: media.url })}
						allowedTypes={['image']}
						value={imageFour}
						render={({ open }) => (
							<>
								{imageFour ? (
									<>
										<div className='bg' style={{ backgroundImage: `url(${imageFour})` }}></div>
										<div className='outer-control'>
										<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageFour: null })}>
											Remove image
										</Button>
										</div>
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>
											Select image
										</Button>
										<span>Recomended size 458x877</span>
									</div>
								)}
							</>
						)}
					/>
				</figure>
				<figure className="img-box header-mosaico-parallax__image">
					<MediaUpload
						onSelect={(media) => setAttributes({ imageFive: media.url })}
						allowedTypes={['image']}
						value={imageFive}
						render={({ open }) => (
							<>
								{imageFive ? (
									<>
										<div className='bg' style={{ backgroundImage: `url(${imageFive})` }}></div>
										<div className='outer-control'>
										<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageFive: null })}>
											Remove image
										</Button>
										</div>
									</>
								) : (
									<div className='outer-control'>
										<Button variant="primary" onClick={open}>
											Select image
										</Button>
										<span>Recomended size 340x618</span>
									</div>
								)}
							</>
						)}
					/>
				</figure>
			</div>
		</section>
	);
}


