import { InnerBlocks, useBlockProps } from '@wordpress/block-editor';
export default function save(props) {
	const { attributes } = props;

	return (
		<section { ...useBlockProps.save() } className="header-mosaico-parallax" data-comp="header-mosaico-parallax">
			<div className="fixed-content">
				{ attributes.title && (<h2>{attributes.title}</h2>) }
			</div> 
			<div class="header-mosaico-parallax__figures">
				<figure className="img-box header-mosaico-parallax__image">
					<div className='bg' style={{ backgroundImage: `url(${attributes.imageOne})` }}></div>
				</figure>
				<figure className="img-box header-mosaico-parallax__image">
					<div className='bg' style={{ backgroundImage: `url(${attributes.imageTwo})` }}></div>
				</figure>
				<figure className="img-box header-mosaico-parallax__image">
					<div className='bg' style={{ backgroundImage: `url(${attributes.imageThree})` }}></div>
				</figure>
				<figure className="img-box header-mosaico-parallax__image">
					<div className='bg' style={{ backgroundImage: `url(${attributes.imageFour})` }}></div>
				</figure>
				<figure className="img-box header-mosaico-parallax__image">
					<div className='bg' style={{ backgroundImage: `url(${attributes.imageFive})` }}></div>
				</figure>
			</div>
		</section>
	);
}
