
import { __ } from '@wordpress/i18n';

import { MediaUpload, RichText, useBlockProps, InspectorControls } from '@wordpress/block-editor';
import { Button, Panel, PanelBody, PanelRow, CheckboxControl } from '@wordpress/components';
import preview from './assets/header-supports-video-or-image.jpg';
import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
	const { title, video, image, imageMobile, sound } = attributes;

	return (
		<section {...useBlockProps()} className="container header block-editor-block-list__block wp-block" data-comp="header" data-preview="true">

			<figure className="preview">
				<img src={preview} alt="" />
			</figure>

			<InspectorControls key='setting'>
				<Panel className="components-panel--custom">
					<PanelBody>
						<PanelRow>
							<MediaUpload
								allowedTypes={['image']}
								onSelect={(media) => {
									setAttributes({ image: media.url });
								}}
								multiple={false}
								render={({ open }) => (
									<div className='block'>
										{image ? (
											<>
												<p>Image desktop</p>
												<img src={image} />
												<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ image: null })}>
													Remove Image
												</Button>
											</>
										) : (
											<>
												<p>Image desktop</p>
												<Button variant="primary" onClick={open}>
													Select Image
												</Button>
											</>
										)}
									</div>
								)}
							/>
							<MediaUpload
								allowedTypes={['image']}
								onSelect={(media) => {
									setAttributes({ imageMobile: media.url });
								}}
								multiple={false}
								render={({ open }) => (
									<div className='block'> 
										{imageMobile ? (
											<>
												<p>Image mobile</p>
												<img src={imageMobile} />
												<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ imageMobile: null })}>
													Remove Image
												</Button>
											</>
										) : (
											<>
												<p>Image mobile</p>
												<Button variant="primary" onClick={open}>
													Select Image
												</Button>
											</>
										)}
									</div>
								)}
							/>
							<MediaUpload
								allowedTypes={['video']}
								onSelect={(media) => {
									setAttributes({ video: media.url });
								}}
								multiple={false}
								render={({ open }) => (
									<>
										{video ? (
											<>
												<video playsInline autoPlay loop muted data-type="autoplay" src={video}></video>
												<Button className="bttn--danger" variant="danger" onClick={() => setAttributes({ video: null })}>
													Remove Video
												</Button>
											</>
										) : (
											<Button variant="primary" onClick={open}>
												Select Video
											</Button>
										)}
									</>
								)}
							/>
							<div className='block'>
								<CheckboxControl
									label="Video have sound?"
									checked={sound}
									onChange={(newValue) => setAttributes({ sound: newValue })}
								/>
							</div>
						</PanelRow>
					</PanelBody>
				</Panel>
			</InspectorControls>
				{ image || imageMobile ? (
				<picture className="img-box">
					<source media="(min-width: 961px)" srcset={image} />
					<source media="(max-width: 960px) and (-webkit-min-device-pixel-ratio: 2)" srcset={imageMobile} />
					<img src={image || imageMobile} alt="" />
				</picture>
				) : (
					video ? (
						<figure className="img-box">
							<video playsInline autoPlay loop muted data-sound={sound}>
								<source src={video} type="video/mp4" />
							</video>
						</figure>
					) : (<figure className="img-box"></figure>)
				)}	
			<div className="row outerText">
				<div className="col-36-36 center">
					<RichText
						placeholder="Enter title here..."
						tagName="h2"
						value={title}
						onChange={(newtitle) => setAttributes({ title: newtitle })}
					/>
				</div>
			</div>
		</section>
	);
}
