import { useBlockProps, RichText } from "@wordpress/block-editor";

export default function save(props) {
	const { attributes } = props;

	return (
		<section
			{...useBlockProps.save()}
			className="container header"
			data-comp="header" data-element="video-container"
		>
			{attributes.image || attributes.imageMobile ? (
				<picture className="img-box">
					<source media="(min-width: 961px)" srcset={attributes.image} />
					<source
						media="(max-width: 960px) and (-webkit-min-device-pixel-ratio: 2)"
						srcset={attributes.imageMobile}
					/>
					<img src={attributes.image || attributes.imageMobile} alt="" />
				</picture>
			) : attributes.video ? (
				<figure className="img-box">
					<video playsInline autoPlay loop muted data-sound={attributes.sound}>
						<source src={attributes.video} type="video/mp4" />
					</video>
				</figure>
			) : (
				<figure className="img-box"></figure>
			)}
			<div className="row outerText">
				<div className="col-36-36 center">
					{attributes.title && (
						<RichText.Content tagName="h2" value={attributes.title} />
					)}
				</div>
			</div>
			{attributes.video && attributes.sound ? (
				<div className="control-video control-video--top mobile" data-comp="control-video-mobile">
					<button className="control-video__button">Sound on</button>
				</div>
			) : ""}
		</section>
	);
}
