import { __ } from "@wordpress/i18n";
import {
	MediaUpload,
	RichText,
	useBlockProps,
	InspectorControls,
} from "@wordpress/block-editor";
import {
	Button,
	Panel,
	PanelBody,
	PanelRow,
	TextControl,
	__experimentalDivider as Divider,
	CheckboxControl,
	ToggleControl,
} from "@wordpress/components";
// import "./editor.scss";

import preview from './assets/header-with-title.jpg';

export default function Edit({ attributes, setAttributes }) {
	const { title, image, imageMobile, video, link, showIcon, isExternal, sound } =
		attributes;
	return (
		<section
			{...useBlockProps()}
			className="container gutenberg-component header-with-title block-editor-block-list__block wp-block"
			data-comp="header-with-title" data-preview="true"
		>

			<figure className="preview">
				<img src={preview} alt="" />
			</figure>

			<InspectorControls key="setting">
				<Panel className="components-panel--custom">
					<PanelBody>
						<PanelRow>
							<MediaUpload
								allowedTypes={["image"]}
								onSelect={(media) => {
									setAttributes({ image: media.url });
								}}
								multiple={false}
								render={({ open }) => (
									<div className="block">
										{image ? (
											<>
												<p>Image desktop</p>
												<img src={image} />
												<Button
													className="bttn--danger"
													variant="danger"
													onClick={() => setAttributes({ image: null })}
												>
													Remove Image
												</Button>
											</>
										) : (
											<>
												<p>Image desktop</p>
												<Button variant="primary" onClick={open}>
													Select Image
												</Button>
											</>
										)}
									</div>
								)}
							/>
							<MediaUpload
								allowedTypes={["image"]}
								onSelect={(media) => {
									setAttributes({ imageMobile: media.url });
								}}
								multiple={false}
								render={({ open }) => (
									<div className="block">
										{imageMobile ? (
											<>
												<p>Image mobile</p>
												<img src={imageMobile} />
												<Button
													className="bttn--danger"
													variant="danger"
													onClick={() => setAttributes({ imageMobile: null })}
												>
													Remove Image
												</Button>
											</>
										) : (
											<>
												<p>Image mobile</p>
												<Button variant="primary" onClick={open}>
													Select Image
												</Button>
											</>
										)}
									</div>
								)}
							/>
							<MediaUpload
								allowedTypes={["video"]}
								onSelect={(media) => {
									setAttributes({ video: media.url });
								}}
								multiple={false}
								render={({ open }) => (
									<>
										{video ? (
											<>
												<video
													playsInline
													autoPlay
													loop
													muted
													data-type="autoplay"
													src={video}
												></video>
												<Button
													className="bttn--danger"
													variant="danger"
													onClick={() => setAttributes({ video: null })}
												>
													Remove Video
												</Button>
											</>
										) : (
											<Button variant="primary" onClick={open}>
												Select Video
											</Button>
										)}
									</>
								)}
							/>
						</PanelRow>
						<Divider orientation="horizontal" />
						<PanelRow>
							<TextControl
								label="CTA Link Optional"
								value={link?.url ?? ""}
								onChange={(val) =>
									setAttributes({
										link: { ...link, url: val },
									})
								}
							/>

							<TextControl
								label="CTA Text Optional"
								value={link?.text ?? ""}
								onChange={(val) =>
									setAttributes({
										link: { ...link, text: val },
									})
								}
							/>
							<ToggleControl
								label="Is a external link?"
								help={
									link?.isExternal
										? "will open on a new tab."
										: "will open in the same page."
								}
								checked={link?.isExternal}
								onChange={(val) =>
									setAttributes({
										link: { ...link, isExternal: val },
									})
								}
							/>
						</PanelRow>
						<Divider orientation="horizontal" />
						<PanelRow>
							<CheckboxControl
								label="Show logo icon"
								checked={showIcon}
								onChange={(val) => setAttributes({ showIcon: val })}
							/>
						</PanelRow>
						<Divider orientation="horizontal" />
						<div className='block'>
							<CheckboxControl
								label="Video have sound?"
								checked={sound}
								onChange={(newValue) => setAttributes({ sound: newValue })}
							/>
						</div>
					</PanelBody>
				</Panel>
			</InspectorControls>
			{image || imageMobile ? (
				<picture className="img-box">
					<source media="(min-width: 961px)" srcSet={image} />
					<source
						media="(max-width: 960px) and (-webkit-min-device-pixel-ratio: 2)"
						srcSet={imageMobile}
					/>
					<img src={image || imageMobile} alt="" />
				</picture>
			) : video ? (
				<figure className="img-box">
					<video playsInline autoPlay loop muted data-sound={sound}>
						<source src={video} type="video/mp4" />
					</video>
				</figure>
			) : (
				<figure className="img-box"></figure>
			)}
			<header className={showIcon ? "" : "no-icon"}>
				<a>
					<RichText
						placeholder="Title..."
						tagName="h2"
						value={title}
						className="after-icon"
						onChange={(newtitle) => setAttributes({ title: newtitle })}
					/>
				</a>
			</header>
		</section>
	);
}
