import { useBlockProps, RichText } from "@wordpress/block-editor";

const TitleComp = (props) => {
	const { title, link } = props;

	return link?.url && link?.text ? (
		<span>
			{title && (
				<RichText.Content
					tagName="h2"
					className="after-icon"
					value={`${title} <i>${link.text ?? "MORE"}</i>`}
				/>
			)}
		</span>
	) : (
		<h2 className="after-icon no-hover">{title}</h2>
	);
};

export default function save(props) {
	const { title, image, imageMobile, video, link, showIcon, sound } =
		props.attributes;

	const ConditionalTag = ({ children, ...props }) => {
		if (!link || !link.url) return <section {...props}>{children}</section>;

		return (
			<a
				href={link.url}
				target={link.isExternal ? "_blank" : "_self"}
				rel="noopener"
				{...props}
			>
				{children}
			</a>
		);
	};

	return (
		<ConditionalTag
			{...useBlockProps.save()}
			className="container gutenberg-component header-with-title"
			data-comp="header-with-title"
			data-element="video-container"
		>
			{image || imageMobile ? (
				<picture className="img-box">
					<source media="(min-width: 961px)" srcset={image} />
					<source
						media="(max-width: 960px) and (-webkit-min-device-pixel-ratio: 2)"
						srcset={imageMobile}
					/>
					<img src={image || imageMobile} alt="" />
				</picture>
			) : video ? (
				<figure className="img-box">
					<video playsInline autoPlay loop muted data-sound={sound}>
						<source src={video} type="video/mp4" />
					</video>
				</figure>
			) : (
				<figure className="img-box"></figure>
			)}
			<header className={showIcon ? "" : "no-icon"}>
				<TitleComp title={title} link={link} />
			</header>
			{video && sound && (
				<div className="control-video mobile" data-comp="control-video-mobile">
					<button className="control-video__button">Sound on</button>
				</div>
			)}
		</ConditionalTag>
	);
}
