import memoize from "memize";
import times from "lodash/times";
import { __ } from "@wordpress/i18n";
import {
	ButtonBlockAppender,
	InnerBlocks,
	useBlockProps,
} from "@wordpress/block-editor";
import { useSelect } from "@wordpress/data";
import preview from "./assets/icon-horizontal-slider.jpg";
import "./editor.scss";

const ALLOWED_BLOCKS = ["nihi/icon-horizontal-slider-item"];
const getCount = memoize((count) => {
	return times(count, () => ["nihi/icon-horizontal-slider-item"]);
});

export default function Edit({ attributes, setAttributes }) {
	const { count } = attributes;
	const { deviceType } = useSelect(
		(select) => ({
			deviceType: select("core/edit-post").__experimentalGetPreviewDeviceType(),
		}),
		[],
	);

	return (
		<section
			{...useBlockProps()}
			className={`container icon-horizontal-slider slider-editor block-editor-block-list__block wp-block ${deviceType}`}
			data-comp="icon-horizontal-slider"
			data-preview="true"
		>
			<figure className="preview">
				<img src={preview} alt="" />
			</figure>

			<div className="row full-width splide--row">
				<article className="col-12-11 offset-left-12-1 splide">
					<ul className="splide__pagination"></ul>
					<div className="splide__track">
						<div className="splide__list">
							<InnerBlocks
								__experimentalCaptureToolbars={true}
								allowedBlocks={ALLOWED_BLOCKS}
								renderAppender={() => (
									<div style={{ marginTop: "10px" }}>
										<Button
											isSecondary
											onClick={() => console.log("Añadir bloque")}
										>
											Añadir Bloque
										</Button>
									</div>
								)}
							/>
						</div>
					</div>
				</article>
			</div>
		</section>
	);
}
